/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http;

import com.arangodb.shaded.vertx.codegen.annotations.CacheReturn;
import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.GoAway;
import com.arangodb.shaded.vertx.core.http.Http2Settings;
import com.arangodb.shaded.vertx.core.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

@VertxGen
public interface HttpConnection {
    default public int getWindowSize() {
        return -1;
    }

    @Fluent
    default public HttpConnection setWindowSize(int windowSize) {
        return this;
    }

    @Fluent
    default public HttpConnection goAway(long errorCode) {
        return this.goAway(errorCode, -1);
    }

    @Fluent
    default public HttpConnection goAway(long errorCode, int lastStreamId) {
        return this.goAway(errorCode, lastStreamId, null);
    }

    @Fluent
    public HttpConnection goAway(long var1, int var3, Buffer var4);

    @Fluent
    public HttpConnection goAwayHandler(@Nullable Handler<GoAway> var1);

    @Fluent
    public HttpConnection shutdownHandler(@Nullable Handler<Void> var1);

    default public void shutdown(Handler<AsyncResult<Void>> handler) {
        this.shutdown(30L, TimeUnit.SECONDS, handler);
    }

    default public Future<Void> shutdown() {
        return this.shutdown(30L, TimeUnit.SECONDS);
    }

    @Deprecated
    default public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        this.shutdown(timeout, TimeUnit.MILLISECONDS, handler);
    }

    @Deprecated
    default public Future<Void> shutdown(long timeoutMs) {
        return this.shutdown(timeoutMs, TimeUnit.MILLISECONDS);
    }

    default public void shutdown(long timeout, TimeUnit unit, Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.shutdown(timeout, unit);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<Void> shutdown(long var1, TimeUnit var3);

    @Fluent
    public HttpConnection closeHandler(Handler<Void> var1);

    public Future<Void> close();

    default public void close(Handler<AsyncResult<Void>> handler) {
        this.close().onComplete(handler);
    }

    public Http2Settings settings();

    public Future<Void> updateSettings(Http2Settings var1);

    @Fluent
    public HttpConnection updateSettings(Http2Settings var1, Handler<AsyncResult<Void>> var2);

    public Http2Settings remoteSettings();

    @Fluent
    public HttpConnection remoteSettingsHandler(Handler<Http2Settings> var1);

    @Fluent
    public HttpConnection ping(Buffer var1, Handler<AsyncResult<Buffer>> var2);

    public Future<Buffer> ping(Buffer var1);

    @Fluent
    public HttpConnection pingHandler(@Nullable Handler<Buffer> var1);

    @Fluent
    public HttpConnection exceptionHandler(Handler<Throwable> var1);

    @CacheReturn
    public SocketAddress remoteAddress();

    public SocketAddress remoteAddress(boolean var1);

    @CacheReturn
    public SocketAddress localAddress();

    public SocketAddress localAddress(boolean var1);

    public boolean isSsl();

    @GenIgnore(value={"permitted-type"})
    public SSLSession sslSession();

    @Deprecated
    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    @GenIgnore
    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException;

    public String indicatedServerName();
}

