/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http;

import com.arangodb.shaded.netty.handler.codec.DecoderResult;
import com.arangodb.shaded.netty.handler.codec.http.HttpResponseStatus;
import com.arangodb.shaded.netty.handler.codec.http.TooLongHttpHeaderException;
import com.arangodb.shaded.netty.handler.codec.http.TooLongHttpLineException;
import com.arangodb.shaded.vertx.codegen.annotations.CacheReturn;
import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.MultiMap;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.Cookie;
import com.arangodb.shaded.vertx.core.http.HttpConnection;
import com.arangodb.shaded.vertx.core.http.HttpFrame;
import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.http.HttpServerFileUpload;
import com.arangodb.shaded.vertx.core.http.HttpServerResponse;
import com.arangodb.shaded.vertx.core.http.HttpVersion;
import com.arangodb.shaded.vertx.core.http.ServerWebSocket;
import com.arangodb.shaded.vertx.core.http.StreamPriority;
import com.arangodb.shaded.vertx.core.net.HostAndPort;
import com.arangodb.shaded.vertx.core.net.NetSocket;
import com.arangodb.shaded.vertx.core.net.SocketAddress;
import com.arangodb.shaded.vertx.core.streams.ReadStream;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

@VertxGen
public interface HttpServerRequest
extends ReadStream<Buffer> {
    @GenIgnore
    public static final Handler<HttpServerRequest> DEFAULT_INVALID_REQUEST_HANDLER = request -> {
        DecoderResult result = request.decoderResult();
        Throwable cause = result.cause();
        HttpResponseStatus status = null;
        if (cause instanceof TooLongHttpLineException) {
            status = HttpResponseStatus.REQUEST_URI_TOO_LONG;
        } else if (cause instanceof TooLongHttpHeaderException) {
            status = HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE;
        }
        if (status == null) {
            status = HttpResponseStatus.BAD_REQUEST;
        }
        HttpServerResponse response = request.response();
        response.setStatusCode(status.code()).end();
        response.close();
    };

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> var1);

    public HttpServerRequest handler(Handler<Buffer> var1);

    public HttpServerRequest pause();

    public HttpServerRequest resume();

    public HttpServerRequest fetch(long var1);

    public HttpServerRequest endHandler(Handler<Void> var1);

    public HttpVersion version();

    public HttpMethod method();

    default public boolean isSSL() {
        return this.connection().isSsl();
    }

    public @Nullable String scheme();

    public String uri();

    public @Nullable String path();

    public @Nullable String query();

    public @Nullable HostAndPort authority();

    @Deprecated
    public @Nullable String host();

    public long bytesRead();

    @CacheReturn
    public HttpServerResponse response();

    @CacheReturn
    public MultiMap headers();

    default public @Nullable String getHeader(String headerName) {
        return this.headers().get(headerName);
    }

    @GenIgnore(value={"permitted-type"})
    default public String getHeader(CharSequence headerName) {
        return this.headers().get(headerName);
    }

    @Fluent
    public HttpServerRequest setParamsCharset(String var1);

    public String getParamsCharset();

    @CacheReturn
    public MultiMap params();

    default public @Nullable String getParam(String paramName) {
        return this.params().get(paramName);
    }

    default public String getParam(String paramName, String defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        String paramValue = this.params().get(paramName);
        return paramValue != null ? paramValue : defaultValue;
    }

    @CacheReturn
    default public SocketAddress remoteAddress() {
        return this.connection().remoteAddress();
    }

    @CacheReturn
    default public SocketAddress localAddress() {
        return this.connection().localAddress();
    }

    @GenIgnore(value={"permitted-type"})
    default public SSLSession sslSession() {
        return this.connection().sslSession();
    }

    @GenIgnore
    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException;

    public String absoluteURI();

    @Fluent
    default public HttpServerRequest bodyHandler(@Nullable Handler<Buffer> bodyHandler) {
        this.body().onSuccess(bodyHandler);
        return this;
    }

    default public HttpServerRequest body(Handler<AsyncResult<Buffer>> handler) {
        this.body().onComplete(handler);
        return this;
    }

    public Future<Buffer> body();

    default public void end(Handler<AsyncResult<Void>> handler) {
        this.end().onComplete(handler);
    }

    public Future<Void> end();

    default public void toNetSocket(Handler<AsyncResult<NetSocket>> handler) {
        Future<NetSocket> fut = this.toNetSocket();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<NetSocket> toNetSocket();

    @Fluent
    public HttpServerRequest setExpectMultipart(boolean var1);

    public boolean isExpectMultipart();

    @Fluent
    public HttpServerRequest uploadHandler(@Nullable Handler<HttpServerFileUpload> var1);

    @CacheReturn
    public MultiMap formAttributes();

    public @Nullable String getFormAttribute(String var1);

    @CacheReturn
    default public int streamId() {
        return -1;
    }

    default public void toWebSocket(Handler<AsyncResult<ServerWebSocket>> handler) {
        Future<ServerWebSocket> fut = this.toWebSocket();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<ServerWebSocket> toWebSocket();

    public boolean isEnded();

    @Fluent
    public HttpServerRequest customFrameHandler(Handler<HttpFrame> var1);

    @CacheReturn
    public HttpConnection connection();

    default public StreamPriority streamPriority() {
        return null;
    }

    @Fluent
    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> var1);

    @GenIgnore
    public DecoderResult decoderResult();

    public @Nullable Cookie getCookie(String var1);

    public @Nullable Cookie getCookie(String var1, String var2, String var3);

    default public int cookieCount() {
        return this.cookies().size();
    }

    @Deprecated
    default public Map<String, Cookie> cookieMap() {
        return this.cookies().stream().collect(Collectors.toMap(Cookie::getName, cookie -> cookie));
    }

    public Set<Cookie> cookies(String var1);

    public Set<Cookie> cookies();

    @Fluent
    default public HttpServerRequest routed(String route) {
        return this;
    }
}

