/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.http.HttpHeaders;
import com.arangodb.shaded.vertx.core.http.HttpServerRequest;
import com.arangodb.shaded.vertx.core.http.ServerWebSocket;
import com.arangodb.shaded.vertx.core.http.impl.Http1xServerRequest;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerConnectionHandler;
import com.arangodb.shaded.vertx.core.http.impl.ServerWebSocketImpl;

public class Http1xServerRequestHandler
implements Handler<HttpServerRequest> {
    private final HttpServerConnectionHandler handlers;

    public Http1xServerRequestHandler(HttpServerConnectionHandler handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(HttpServerRequest req) {
        Handler<ServerWebSocket> wsHandler = this.handlers.wsHandler;
        Handler<HttpServerRequest> reqHandler = this.handlers.requestHandler;
        if (wsHandler != null) {
            if (req.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true) && this.handlers.server.wsAccept()) {
                ((Http1xServerRequest)req).webSocket().onComplete(ar -> {
                    if (ar.succeeded()) {
                        ServerWebSocketImpl ws = (ServerWebSocketImpl)ar.result();
                        wsHandler.handle(ws);
                        ws.tryHandshake(101);
                    }
                });
            } else if (reqHandler != null) {
                reqHandler.handle(req);
            } else {
                req.response().setStatusCode(400).end();
            }
        } else if (req.version() == null) {
            req.response().setStatusCode(501).end();
            req.response().close();
        } else {
            reqHandler.handle(req);
        }
    }
}

