/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.http.HttpClient;
import com.arangodb.shaded.vertx.core.http.HttpClientBuilder;
import com.arangodb.shaded.vertx.core.http.HttpClientOptions;
import com.arangodb.shaded.vertx.core.http.HttpClientResponse;
import com.arangodb.shaded.vertx.core.http.HttpConnection;
import com.arangodb.shaded.vertx.core.http.PoolOptions;
import com.arangodb.shaded.vertx.core.http.RequestOptions;
import com.arangodb.shaded.vertx.core.http.impl.SharedHttpClient;
import com.arangodb.shaded.vertx.core.impl.CloseFuture;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import java.util.function.Function;

public class HttpClientBuilderImpl
implements HttpClientBuilder {
    private final VertxInternal vertx;
    private HttpClientOptions clientOptions;
    private PoolOptions poolOptions;
    private Handler<HttpConnection> connectHandler;
    private Function<HttpClientResponse, Future<RequestOptions>> redirectHandler;

    public HttpClientBuilderImpl(VertxInternal vertx) {
        this.vertx = vertx;
    }

    @Override
    public HttpClientBuilder with(HttpClientOptions options) {
        this.clientOptions = options;
        return this;
    }

    @Override
    public HttpClientBuilder with(PoolOptions options) {
        this.poolOptions = options;
        return this;
    }

    @Override
    public HttpClientBuilder withConnectHandler(Handler<HttpConnection> handler) {
        this.connectHandler = handler;
        return this;
    }

    @Override
    public HttpClientBuilder withRedirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        this.redirectHandler = handler;
        return this;
    }

    private CloseFuture resolveCloseFuture() {
        ContextInternal context = this.vertx.getContext();
        return context != null ? context.closeFuture() : this.vertx.closeFuture();
    }

    @Override
    public HttpClient build() {
        Function<HttpClientResponse, Future<RequestOptions>> redirectHandler;
        HttpClient client;
        HttpClientOptions co = this.clientOptions != null ? this.clientOptions : new HttpClientOptions();
        PoolOptions po = this.poolOptions != null ? this.poolOptions : new PoolOptions();
        CloseFuture closeFuture = new CloseFuture();
        if (co.isShared()) {
            client = this.vertx.createSharedClient("__vertx.shared.httpClients", co.getName(), closeFuture, cf -> this.vertx.createHttpPoolClient(co, po, (CloseFuture)cf));
            client = new SharedHttpClient(this.vertx, closeFuture, client);
        } else {
            client = this.vertx.createHttpPoolClient(co, po, closeFuture);
        }
        Handler<HttpConnection> connectHandler = this.connectHandler;
        if (connectHandler != null) {
            client.connectionHandler(connectHandler);
        }
        if ((redirectHandler = this.redirectHandler) != null) {
            client.redirectHandler(redirectHandler);
        }
        this.resolveCloseFuture().add(closeFuture);
        return client;
    }
}

