/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.netty.channel.ChannelPipeline;
import com.arangodb.shaded.netty.handler.codec.compression.ZlibCodecFactory;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.http.HttpConnection;
import com.arangodb.shaded.vertx.core.http.HttpServerRequest;
import com.arangodb.shaded.vertx.core.http.ServerWebSocket;
import com.arangodb.shaded.vertx.core.http.impl.Http1xServerConnection;
import com.arangodb.shaded.vertx.core.http.impl.Http1xServerRequestHandler;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpServerImpl;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import java.util.ArrayList;

public class HttpServerConnectionHandler
implements Handler<HttpServerConnection> {
    final HttpServerImpl server;
    final Handler<HttpServerRequest> requestHandler;
    final Handler<HttpServerRequest> invalidRequestHandler;
    final Handler<ServerWebSocket> wsHandler;
    final Handler<HttpConnection> connectionHandler;
    final Handler<Throwable> exceptionHandler;

    public HttpServerConnectionHandler(HttpServerImpl server, Handler<HttpServerRequest> requestHandler, Handler<HttpServerRequest> invalidRequestHandler, Handler<ServerWebSocket> wsHandler, Handler<HttpConnection> connectionHandler, Handler<Throwable> exceptionHandler) {
        this.server = server;
        this.requestHandler = requestHandler;
        this.invalidRequestHandler = invalidRequestHandler == null ? HttpServerRequest.DEFAULT_INVALID_REQUEST_HANDLER : invalidRequestHandler;
        this.wsHandler = wsHandler;
        this.connectionHandler = connectionHandler;
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServerConnection conn) {
        Http1xServerRequestHandler requestHandler = this.requestHandler;
        if (!HttpServerImpl.DISABLE_WEBSOCKETS && conn instanceof Http1xServerConnection) {
            requestHandler = new Http1xServerRequestHandler(this);
            Http1xServerConnection c = (Http1xServerConnection)conn;
            this.initializeWebSocketExtensions(c.channelHandlerContext().pipeline());
        }
        conn.exceptionHandler(this.exceptionHandler);
        conn.handler(requestHandler);
        conn.invalidRequestHandler(this.invalidRequestHandler);
        if (this.connectionHandler != null) {
            ContextInternal ctx = conn.getContext();
            ContextInternal prev = ctx.beginDispatch();
            try {
                this.connectionHandler.handle(conn);
            }
            catch (Exception e) {
                ctx.reportException(e);
            }
            finally {
                ctx.endDispatch(prev);
            }
        }
    }

    private void initializeWebSocketExtensions(ChannelPipeline pipeline) {
        ArrayList<WebSocketServerExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketServerExtensionHandshaker>();
        if (this.server.options.getPerFrameWebSocketCompressionSupported()) {
            extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.server.options.getWebSocketCompressionLevel()));
        }
        if (this.server.options.getPerMessageWebSocketCompressionSupported()) {
            extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.server.options.getWebSocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, this.server.options.getWebSocketAllowServerNoContext(), this.server.options.getWebSocketPreferredClientNoContext()));
        }
        if (!extensionHandshakers.isEmpty()) {
            WebSocketServerExtensionHandler extensionHandler = new WebSocketServerExtensionHandler(extensionHandshakers.toArray(new WebSocketServerExtensionHandshaker[0]));
            pipeline.addBefore("handler", "webSocketExtensionHandler", extensionHandler);
        }
    }
}

