/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.MultiMap;
import com.arangodb.shaded.vertx.core.http.HttpClient;
import com.arangodb.shaded.vertx.core.http.HttpClientOptions;
import com.arangodb.shaded.vertx.core.http.HttpClientRequest;
import com.arangodb.shaded.vertx.core.http.HttpClientResponse;
import com.arangodb.shaded.vertx.core.http.HttpConnection;
import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.http.RequestOptions;
import com.arangodb.shaded.vertx.core.http.WebSocket;
import com.arangodb.shaded.vertx.core.http.WebSocketConnectOptions;
import com.arangodb.shaded.vertx.core.http.WebsocketVersion;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientConnection;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientInternal;
import com.arangodb.shaded.vertx.core.impl.CloseFuture;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.net.SSLOptions;
import com.arangodb.shaded.vertx.core.net.SocketAddress;
import java.util.List;
import java.util.function.Function;

public class SharedHttpClient
implements HttpClientInternal {
    public static final String SHARED_MAP_NAME = "__vertx.shared.httpClients";
    private final VertxInternal vertx;
    private final CloseFuture closeFuture;
    private final HttpClientInternal delegate;

    public SharedHttpClient(VertxInternal vertx, CloseFuture closeFuture, HttpClient delegate) {
        this.vertx = vertx;
        this.closeFuture = closeFuture;
        this.delegate = (HttpClientInternal)delegate;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        this.closeFuture.close(handler != null ? closingCtx.promise(handler) : null);
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = closingCtx.promise();
        this.closeFuture.close(promise);
        return promise.future();
    }

    @Override
    public void request(RequestOptions options, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(options, handler);
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions options) {
        return this.delegate.request(options);
    }

    @Override
    public void request(HttpMethod method, int port, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, port, host, requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, int port, String host, String requestURI) {
        return this.delegate.request(method, port, host, requestURI);
    }

    @Override
    public void request(HttpMethod method, String host, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, host, requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String host, String requestURI) {
        return this.delegate.request(method, host, requestURI);
    }

    @Override
    public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.delegate.request(method, requestURI, handler);
    }

    @Override
    public Future<HttpClientRequest> request(HttpMethod method, String requestURI) {
        return this.delegate.request(method, requestURI);
    }

    @Override
    public void webSocket(int port, String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(port, host, requestURI, handler);
    }

    @Override
    public Future<WebSocket> webSocket(int port, String host, String requestURI) {
        return this.delegate.webSocket(port, host, requestURI);
    }

    @Override
    public void webSocket(String host, String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(host, requestURI, handler);
    }

    @Override
    public Future<WebSocket> webSocket(String host, String requestURI) {
        return this.delegate.webSocket(host, requestURI);
    }

    @Override
    public void webSocket(String requestURI, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(requestURI, handler);
    }

    @Override
    public Future<WebSocket> webSocket(String requestURI) {
        return this.delegate.webSocket(requestURI);
    }

    @Override
    public void webSocket(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocket(options, handler);
    }

    @Override
    public Future<WebSocket> webSocket(WebSocketConnectOptions options) {
        return this.delegate.webSocket(options);
    }

    @Override
    public void webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.webSocketAbs(url, headers, version, subProtocols, handler);
    }

    @Override
    public Future<WebSocket> webSocketAbs(String url, MultiMap headers, WebsocketVersion version, List<String> subProtocols) {
        return this.delegate.webSocketAbs(url, headers, version, subProtocols);
    }

    @Override
    public Future<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        return this.delegate.updateSSLOptions(options, force);
    }

    @Override
    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        return this.delegate.connectionHandler(handler);
    }

    @Override
    public HttpClient redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> handler) {
        return this.delegate.redirectHandler(handler);
    }

    @Override
    public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
        return this.delegate.redirectHandler();
    }

    @Override
    public VertxInternal vertx() {
        return this.delegate.vertx();
    }

    @Override
    public HttpClientOptions options() {
        return this.delegate.options();
    }

    @Override
    public Future<HttpClientConnection> connect(SocketAddress server, SocketAddress peer) {
        return this.delegate.connect(server, peer);
    }
}

