/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.http.ClientWebSocket;
import com.arangodb.shaded.vertx.core.http.WebSocket;
import com.arangodb.shaded.vertx.core.http.WebSocketClient;
import com.arangodb.shaded.vertx.core.http.WebSocketConnectOptions;
import com.arangodb.shaded.vertx.core.impl.CloseFuture;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.VertxInternal;
import com.arangodb.shaded.vertx.core.impl.future.PromiseInternal;
import com.arangodb.shaded.vertx.core.net.SSLOptions;

public class SharedWebSocketClient
implements WebSocketClient {
    public static final String SHARED_MAP_NAME = "__vertx.shared.webSocketClients";
    private final VertxInternal vertx;
    private final CloseFuture closeFuture;
    private final WebSocketClient delegate;

    public SharedWebSocketClient(VertxInternal vertx, CloseFuture closeFuture, WebSocketClient delegate) {
        this.vertx = vertx;
        this.closeFuture = closeFuture;
        this.delegate = delegate;
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        this.closeFuture.close(handler != null ? closingCtx.promise(handler) : null);
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal<Void> promise = closingCtx.promise();
        this.closeFuture.close(promise);
        return promise.future();
    }

    @Override
    public ClientWebSocket webSocket() {
        return this.delegate.webSocket();
    }

    @Override
    public void connect(WebSocketConnectOptions options, Handler<AsyncResult<WebSocket>> handler) {
        this.delegate.connect(options, handler);
    }

    @Override
    public Future<WebSocket> connect(WebSocketConnectOptions options) {
        return this.delegate.connect(options);
    }

    @Override
    public Future<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        return this.delegate.updateSSLOptions(options, force);
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.delegate.isMetricsEnabled();
    }
}

