/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.http.impl.ClientHttpEndpointBase;
import com.arangodb.shaded.vertx.core.http.impl.HttpChannelConnector;
import com.arangodb.shaded.vertx.core.http.impl.HttpClientConnection;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.spi.metrics.ClientMetrics;
import java.util.ArrayDeque;
import java.util.Deque;

class WebSocketEndpoint
extends ClientHttpEndpointBase<HttpClientConnection> {
    private final int maxPoolSize;
    private final HttpChannelConnector connector;
    private final Deque<Waiter> waiters;
    private int inflightConnections;

    WebSocketEndpoint(ClientMetrics metrics, int maxPoolSize, HttpChannelConnector connector, Runnable dispose) {
        super(metrics, dispose);
        this.maxPoolSize = maxPoolSize;
        this.connector = connector;
        this.waiters = new ArrayDeque<Waiter>();
    }

    private void tryConnect(ContextInternal ctx, final Handler<AsyncResult<HttpClientConnection>> handler) {
        ContextInternal eventLoopContext = ctx.isEventLoopContext() ? ctx : ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        class Listener
        implements Handler<AsyncResult<HttpClientConnection>> {
            Listener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void onEvict() {
                Waiter h;
                WebSocketEndpoint.this.decRefCount();
                WebSocketEndpoint webSocketEndpoint = WebSocketEndpoint.this;
                synchronized (webSocketEndpoint) {
                    if (--WebSocketEndpoint.this.inflightConnections > WebSocketEndpoint.this.maxPoolSize || WebSocketEndpoint.this.waiters.isEmpty()) {
                        return;
                    }
                    h = (Waiter)WebSocketEndpoint.this.waiters.poll();
                }
                WebSocketEndpoint.this.tryConnect(h.context, h.handler);
            }

            @Override
            public void handle(AsyncResult<HttpClientConnection> ar) {
                if (ar.succeeded()) {
                    HttpClientConnection c = ar.result();
                    if (WebSocketEndpoint.this.incRefCount()) {
                        c.evictionHandler(v -> this.onEvict());
                        handler.handle(Future.succeededFuture(c));
                    } else {
                        c.close();
                        handler.handle(Future.failedFuture("Connection closed"));
                    }
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        }
        this.connector.httpConnect(eventLoopContext, new Listener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestConnection2(ContextInternal ctx, long timeout, Handler<AsyncResult<HttpClientConnection>> handler) {
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            if (this.inflightConnections >= this.maxPoolSize) {
                this.waiters.add(new Waiter(handler, ctx));
                return;
            }
            ++this.inflightConnections;
        }
        this.tryConnect(ctx, handler);
    }

    @Override
    void checkExpired() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            this.waiters.forEach(waiter -> waiter.context.runOnContext(v -> waiter.handler.handle(Future.failedFuture("Closed"))));
            this.waiters.clear();
        }
    }

    private static class Waiter {
        final Handler<AsyncResult<HttpClientConnection>> handler;
        final ContextInternal context;

        Waiter(Handler<AsyncResult<HttpClientConnection>> handler, ContextInternal context) {
            this.handler = handler;
            this.context = context;
        }
    }
}

