/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.netty.buffer.ByteBuf;
import com.arangodb.shaded.netty.channel.ChannelFuture;
import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelInboundHandlerAdapter;
import com.arangodb.shaded.netty.channel.ChannelPipeline;
import com.arangodb.shaded.netty.handler.codec.http.DefaultFullHttpResponse;
import com.arangodb.shaded.netty.handler.codec.http.FullHttpResponse;
import com.arangodb.shaded.netty.handler.codec.http.HttpContent;
import com.arangodb.shaded.netty.handler.codec.http.HttpContentDecompressor;
import com.arangodb.shaded.netty.handler.codec.http.HttpResponse;
import com.arangodb.shaded.netty.handler.codec.http.LastHttpContent;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.arangodb.shaded.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import com.arangodb.shaded.netty.util.concurrent.GenericFutureListener;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.UpgradeRejectedException;
import com.arangodb.shaded.vertx.core.http.impl.headers.HeadersAdaptor;

class WebSocketHandshakeInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Handler<AsyncResult<HeadersAdaptor>> wsHandler;
    private final WebSocketClientHandshaker handshaker;
    private ChannelHandlerContext chctx;
    private FullHttpResponse response;
    private ChannelFuture fut;

    WebSocketHandshakeInboundHandler(WebSocketClientHandshaker handshaker, Handler<AsyncResult<HeadersAdaptor>> wsHandler) {
        this.handshaker = handshaker;
        this.wsHandler = wsHandler;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.chctx = ctx;
        this.fut = this.handshaker.handshake(ctx.channel());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.wsHandler.handle(Future.failedFuture(new WebSocketHandshakeException("Connection closed while handshake in process")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse resp = (HttpResponse)msg;
            this.response = new DefaultFullHttpResponse(resp.protocolVersion(), resp.status());
            this.response.headers().add(resp.headers());
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            try {
                if (this.response != null) {
                    this.response.content().writeBytes(content.content());
                    if (msg instanceof LastHttpContent) {
                        this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                        ChannelPipeline pipeline = this.chctx.pipeline();
                        pipeline.remove(this);
                        HttpContentDecompressor handler = pipeline.get(HttpContentDecompressor.class);
                        if (handler != null) {
                            ctx.pipeline().remove(handler);
                        }
                        this.handshakeComplete(this.response);
                    }
                }
            }
            finally {
                content.release();
            }
        }
    }

    private void handshakeComplete(FullHttpResponse response) {
        int sc = response.status().code();
        if (sc != 101) {
            String msg = "WebSocket upgrade failure: " + sc;
            ByteBuf content = response.content();
            UpgradeRejectedException failure = new UpgradeRejectedException(msg, sc, new HeadersAdaptor(response.headers()), content != null ? Buffer.buffer(content) : null);
            this.wsHandler.handle(Future.failedFuture(failure));
        } else {
            this.fut.addListener((GenericFutureListener<? extends com.arangodb.shaded.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<com.arangodb.shaded.netty.util.concurrent.Future>)future -> {
                Future<Object> res;
                if (future.isSuccess()) {
                    try {
                        this.handshaker.finishHandshake(this.chctx.channel(), response);
                        res = Future.succeededFuture(new HeadersAdaptor(response.headers()));
                    }
                    catch (WebSocketHandshakeException e) {
                        res = Future.failedFuture(e);
                    }
                } else {
                    res = Future.failedFuture(future.cause());
                }
                this.wsHandler.handle(res);
            }));
        }
    }
}

