/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl;

import com.arangodb.shaded.vertx.core.http.WebSocket;
import com.arangodb.shaded.vertx.core.http.impl.Http1xClientConnection;
import com.arangodb.shaded.vertx.core.http.impl.WebSocketImplBase;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.spi.metrics.HttpClientMetrics;
import com.arangodb.shaded.vertx.core.spi.metrics.Metrics;

public class WebSocketImpl
extends WebSocketImplBase<WebSocketImpl>
implements WebSocket {
    private final Http1xClientConnection conn;
    private final long closingTimeoutMS;

    public WebSocketImpl(ContextInternal context, Http1xClientConnection conn, boolean supportsContinuation, long closingTimeout, int maxWebSocketFrameSize, int maxWebSocketMessageSize, boolean registerWebSocketWriteHandlers) {
        super(context, conn, supportsContinuation, maxWebSocketFrameSize, maxWebSocketMessageSize, registerWebSocketWriteHandlers);
        this.conn = conn;
        this.closingTimeoutMS = closingTimeout >= 0L ? closingTimeout * 1000L : -1L;
    }

    @Override
    protected void handleCloseConnection() {
        if (this.closingTimeoutMS == 0L) {
            this.closeConnection();
        } else if (this.closingTimeoutMS > 0L) {
            this.initiateConnectionCloseTimeout(this.closingTimeoutMS);
        }
    }

    @Override
    protected void handleClose(boolean graceful) {
        HttpClientMetrics metrics = this.conn.metrics();
        if (Metrics.METRICS_ENABLED && metrics != null) {
            metrics.disconnected(this.getMetric());
            this.setMetric(null);
        }
        super.handleClose(graceful);
    }
}

