/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.http.impl.headers;

import com.arangodb.shaded.netty.handler.codec.http.HttpHeaders;
import com.arangodb.shaded.vertx.core.MultiMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HeadersAdaptor
implements MultiMap {
    private final HttpHeaders headers;

    public HeadersAdaptor(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public String get(String name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAll(name);
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        return this.headers.entries();
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public Set<String> names() {
        return this.headers.names();
    }

    @Override
    public MultiMap add(String name, String value) {
        this.headers.add(name, (Object)value);
        return this;
    }

    @Override
    public MultiMap add(String name, Iterable<String> values) {
        this.headers.add(name, values);
        return this;
    }

    @Override
    public MultiMap addAll(MultiMap headers) {
        for (Map.Entry<String, String> entry : headers.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap addAll(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap set(String name, String value) {
        if (value != null) {
            this.headers.set(name, (Object)value);
        } else {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public MultiMap set(String name, Iterable<String> values) {
        this.headers.set(name, values);
        return this;
    }

    @Override
    public MultiMap setAll(MultiMap httpHeaders) {
        this.clear();
        for (Map.Entry entry : httpHeaders) {
            this.add((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    @Override
    public MultiMap remove(String name) {
        this.headers.remove(name);
        return this;
    }

    @Override
    public MultiMap clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.headers.iteratorAsString();
    }

    @Override
    public int size() {
        return this.names().size();
    }

    @Override
    public MultiMap setAll(Map<String, String> headers) {
        this.clear();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public String get(CharSequence name) {
        return this.headers.get(name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.headers.getAll(name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    @Override
    public boolean contains(String name, String value, boolean caseInsensitive) {
        return this.headers.contains(name, value, caseInsensitive);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean caseInsensitive) {
        return this.headers.contains(name, value, caseInsensitive);
    }

    @Override
    public MultiMap add(CharSequence name, CharSequence value) {
        this.headers.add(name, (Object)value);
        return this;
    }

    @Override
    public MultiMap add(CharSequence name, Iterable<CharSequence> values) {
        this.headers.add(name, values);
        return this;
    }

    @Override
    public MultiMap set(CharSequence name, CharSequence value) {
        if (value != null) {
            this.headers.set(name, (Object)value);
        } else {
            this.headers.remove(name);
        }
        return this;
    }

    @Override
    public MultiMap set(CharSequence name, Iterable<CharSequence> values) {
        this.headers.set(name, values);
        return this;
    }

    @Override
    public MultiMap remove(CharSequence name) {
        this.headers.remove(name);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this) {
            sb.append(entry).append('\n');
        }
        return sb.toString();
    }
}

