/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl;

import com.arangodb.shaded.vertx.core.impl.ContextLocalImpl;
import com.arangodb.shaded.vertx.core.spi.context.storage.AccessMode;
import com.arangodb.shaded.vertx.core.spi.context.storage.ContextLocal;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;

class ContextBase
extends AtomicReferenceArray<Object> {
    private final int localsLength;

    ContextBase(int localsLength) {
        super(localsLength);
        this.localsLength = localsLength;
    }

    ContextBase(ContextBase another) {
        super(another.localsLength);
        this.localsLength = another.localsLength;
    }

    public final <T> T getLocal(ContextLocal<T> key, AccessMode accessMode) {
        ContextLocalImpl internalKey = (ContextLocalImpl)key;
        int index = internalKey.index;
        if (index >= this.localsLength) {
            throw new IllegalArgumentException();
        }
        Object res = accessMode.get(this, index);
        return (T)res;
    }

    public final <T> T getLocal(ContextLocal<T> key, AccessMode accessMode, Supplier<? extends T> initialValueSupplier) {
        ContextLocalImpl internalKey = (ContextLocalImpl)key;
        int index = internalKey.index;
        if (index >= this.localsLength) {
            throw new IllegalArgumentException("Invalid key index: " + index);
        }
        Object res = accessMode.getOrCreate(this, index, initialValueSupplier);
        return (T)res;
    }

    public final <T> void putLocal(ContextLocal<T> key, AccessMode accessMode, T value) {
        ContextLocalImpl internalKey = (ContextLocalImpl)key;
        int index = internalKey.index;
        if (index >= this.localsLength) {
            throw new IllegalArgumentException();
        }
        accessMode.put(this, index, value);
    }
}

