/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl.future;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.CompositeFuture;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.impl.future.FutureImpl;
import com.arangodb.shaded.vertx.core.impl.future.FutureInternal;
import com.arangodb.shaded.vertx.core.impl.future.Listener;

public class CompositeFutureImpl
extends FutureImpl<CompositeFuture>
implements CompositeFuture,
Listener<Object> {
    private static final int OP_ALL = 0;
    private static final int OP_ANY = 1;
    private static final int OP_JOIN = 2;
    private final Future<?>[] results;
    private final int op;
    private boolean initializing;
    private Object completed;
    private int completions;

    public static CompositeFuture all(Future<?> ... results) {
        return CompositeFutureImpl.create(0, results);
    }

    public static CompositeFuture any(Future<?> ... results) {
        return CompositeFutureImpl.create(1, results);
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.create(2, results);
    }

    private static CompositeFuture create(int op, Future<?> ... results) {
        CompositeFutureImpl composite;
        int len = results.length;
        if (len > 0) {
            composite = new CompositeFutureImpl(op, true, results);
            composite.init();
        } else {
            composite = new CompositeFutureImpl(op, false, results);
            composite.complete(composite);
        }
        return composite;
    }

    private CompositeFutureImpl(int op, boolean initializing, Future<?> ... results) {
        this.op = op;
        this.initializing = initializing;
        this.results = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object o;
        for (Future<?> result : this.results) {
            FutureInternal internal = (FutureInternal)result;
            internal.addListener(this);
        }
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            this.initializing = false;
            o = this.completed;
            if (o == null) {
                return;
            }
        }
        this.complete(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(Object value) {
        Object completion;
        int len = this.results.length;
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            int val = ++this.completions;
            if (this.completed != null) {
                return;
            }
            switch (this.op) {
                case 0: {
                    if (val < len) {
                        return;
                    }
                    completion = this;
                    break;
                }
                case 1: {
                    completion = this;
                    break;
                }
                case 2: {
                    if (val < len) {
                        return;
                    }
                    completion = this.anyFailureOrThis();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.completed = completion;
            if (this.initializing) {
                return;
            }
        }
        this.complete(completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(Throwable failure) {
        Object completion;
        int len = this.results.length;
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            int val = ++this.completions;
            if (this.completed != null) {
                return;
            }
            switch (this.op) {
                case 0: {
                    completion = failure;
                    break;
                }
                case 1: {
                    if (val < len) {
                        return;
                    }
                    completion = failure;
                    break;
                }
                case 2: {
                    if (val < len) {
                        return;
                    }
                    completion = this.anyFailureOrThis();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.completed = completion;
            if (this.initializing) {
                return;
            }
        }
        this.complete(completion);
    }

    private Object anyFailureOrThis() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Future<?> res = this.results[i];
            if (res.succeeded()) continue;
            return res.cause();
        }
        return this;
    }

    @Override
    public Throwable cause(int index) {
        return this.future(index).cause();
    }

    @Override
    public boolean succeeded(int index) {
        return this.future(index).succeeded();
    }

    @Override
    public boolean failed(int index) {
        return this.future(index).failed();
    }

    @Override
    public boolean isComplete(int index) {
        return this.future(index).isComplete();
    }

    @Override
    public <T> T resultAt(int index) {
        return this.future(index).result();
    }

    private <T> Future<T> future(int index) {
        if (index < 0 || index >= this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    private void complete(Object result) {
        for (Future<?> r : this.results) {
            FutureInternal internal = (FutureInternal)r;
            internal.removeListener(this);
        }
        if (result == this) {
            this.tryComplete(this);
        } else if (result instanceof Throwable) {
            this.tryFail((Throwable)result);
        }
    }

    @Override
    public CompositeFuture onComplete(Handler<AsyncResult<CompositeFuture>> handler) {
        return (CompositeFuture)super.onComplete(handler);
    }

    @Override
    public CompositeFuture onSuccess(Handler<CompositeFuture> handler) {
        return (CompositeFuture)super.onSuccess(handler);
    }

    @Override
    public CompositeFuture onFailure(Handler<Throwable> handler) {
        return (CompositeFuture)super.onFailure(handler);
    }

    @Override
    protected void formatValue(Object value, StringBuilder sb) {
        sb.append('(');
        for (int i = 0; i < this.results.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.results[i]);
        }
        sb.append(')');
    }
}

