/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl.future;

import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.impl.ContextInternal;
import com.arangodb.shaded.vertx.core.impl.future.FutureInternal;
import com.arangodb.shaded.vertx.core.impl.future.Listener;
import com.arangodb.shaded.vertx.core.impl.future.Operation;
import java.util.function.Function;

class Composition<T, U>
extends Operation<U>
implements Listener<T> {
    private final Function<T, Future<U>> successMapper;
    private final Function<Throwable, Future<U>> failureMapper;

    Composition(ContextInternal context, Function<T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        super(context);
        this.successMapper = successMapper;
        this.failureMapper = failureMapper;
    }

    @Override
    public void onSuccess(T value) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.successMapper.apply(value);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    @Override
    public void onFailure(Throwable failure) {
        FutureInternal future;
        try {
            future = (FutureInternal)this.failureMapper.apply(failure);
        }
        catch (Throwable e) {
            this.tryFail(e);
            return;
        }
        future.addListener(this.newListener());
    }

    private Listener<U> newListener() {
        return new Listener<U>(){

            @Override
            public void onSuccess(U value) {
                Composition.this.tryComplete(value);
            }

            @Override
            public void onFailure(Throwable failure) {
                Composition.this.tryFail(failure);
            }
        };
    }
}

