/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.impl.transports;

import com.arangodb.shaded.netty.channel.Channel;
import com.arangodb.shaded.netty.channel.ChannelFactory;
import com.arangodb.shaded.netty.channel.EventLoopGroup;
import com.arangodb.shaded.netty.channel.ServerChannel;
import com.arangodb.shaded.netty.channel.nio.NioEventLoopGroup;
import com.arangodb.shaded.netty.channel.socket.DatagramChannel;
import com.arangodb.shaded.netty.channel.socket.InternetProtocolFamily;
import com.arangodb.shaded.netty.channel.socket.nio.NioDatagramChannel;
import com.arangodb.shaded.netty.channel.socket.nio.NioServerSocketChannel;
import com.arangodb.shaded.netty.channel.socket.nio.NioSocketChannel;
import com.arangodb.shaded.vertx.core.spi.transport.Transport;
import java.util.concurrent.ThreadFactory;

public class JDKTransport
implements Transport {
    public static final Transport INSTANCE = new JDKTransport();

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new NioDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        switch (family) {
            case IPv4: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv4);
            }
            case IPv6: {
                return new NioDatagramChannel(InternetProtocolFamily.IPv6);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException("The Vertx instance must be created with the preferNativeTransport option set to true to create domain sockets");
        }
        return NioSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            throw new IllegalArgumentException();
        }
        return NioServerSocketChannel::new;
    }
}

