/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net;

import com.arangodb.shaded.netty.handler.logging.ByteBufFormat;
import com.arangodb.shaded.vertx.codegen.annotations.DataObject;
import com.arangodb.shaded.vertx.codegen.json.annotations.JsonGen;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.net.ClientOptionsBaseConverter;
import com.arangodb.shaded.vertx.core.net.JdkSSLEngineOptions;
import com.arangodb.shaded.vertx.core.net.JksOptions;
import com.arangodb.shaded.vertx.core.net.KeyCertOptions;
import com.arangodb.shaded.vertx.core.net.OpenSSLEngineOptions;
import com.arangodb.shaded.vertx.core.net.PemKeyCertOptions;
import com.arangodb.shaded.vertx.core.net.PemTrustOptions;
import com.arangodb.shaded.vertx.core.net.PfxOptions;
import com.arangodb.shaded.vertx.core.net.ProxyOptions;
import com.arangodb.shaded.vertx.core.net.SSLEngineOptions;
import com.arangodb.shaded.vertx.core.net.TCPSSLOptions;
import com.arangodb.shaded.vertx.core.net.TrustOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public abstract class ClientOptionsBase
extends TCPSSLOptions {
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final String DEFAULT_METRICS_NAME = "";
    private int connectTimeout;
    private boolean trustAll;
    private String metricsName;
    private ProxyOptions proxyOptions;
    private String localAddress;
    private List<String> nonProxyHosts;

    public ClientOptionsBase() {
        this.init();
    }

    public ClientOptionsBase(ClientOptionsBase other) {
        super(other);
        this.connectTimeout = other.getConnectTimeout();
        this.trustAll = other.isTrustAll();
        this.metricsName = other.metricsName;
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
        this.localAddress = other.localAddress;
        this.nonProxyHosts = other.nonProxyHosts != null ? new ArrayList<String>(other.nonProxyHosts) : null;
    }

    public ClientOptionsBase(JsonObject json) {
        super(json);
        this.init();
        ClientOptionsBaseConverter.fromJson(json, this);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ClientOptionsBaseConverter.toJson(this, json);
        return json;
    }

    private void init() {
        this.connectTimeout = 60000;
        this.trustAll = false;
        this.metricsName = DEFAULT_METRICS_NAME;
        this.proxyOptions = null;
        this.localAddress = null;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public ClientOptionsBase setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientOptionsBase setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public ClientOptionsBase setMetricsName(String metricsName) {
        this.metricsName = metricsName;
        return this;
    }

    public ClientOptionsBase setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public List<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public ClientOptionsBase setNonProxyHosts(List<String> nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
        return this;
    }

    public ClientOptionsBase addNonProxyHost(String host) {
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = new ArrayList<String>();
        }
        this.nonProxyHosts.add(host);
        return this;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public ClientOptionsBase setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    @Override
    public ClientOptionsBase setLogActivity(boolean logEnabled) {
        return (ClientOptionsBase)super.setLogActivity(logEnabled);
    }

    @Override
    public ClientOptionsBase setActivityLogDataFormat(ByteBufFormat activityLogDataFormat) {
        return (ClientOptionsBase)super.setActivityLogDataFormat(activityLogDataFormat);
    }

    @Override
    public ClientOptionsBase setTcpNoDelay(boolean tcpNoDelay) {
        return (ClientOptionsBase)super.setTcpNoDelay(tcpNoDelay);
    }

    @Override
    public ClientOptionsBase setTcpKeepAlive(boolean tcpKeepAlive) {
        return (ClientOptionsBase)super.setTcpKeepAlive(tcpKeepAlive);
    }

    @Override
    public ClientOptionsBase setSoLinger(int soLinger) {
        return (ClientOptionsBase)super.setSoLinger(soLinger);
    }

    @Override
    public ClientOptionsBase setIdleTimeout(int idleTimeout) {
        return (ClientOptionsBase)super.setIdleTimeout(idleTimeout);
    }

    @Override
    public ClientOptionsBase setReadIdleTimeout(int idleTimeout) {
        return (ClientOptionsBase)super.setReadIdleTimeout(idleTimeout);
    }

    @Override
    public ClientOptionsBase setWriteIdleTimeout(int idleTimeout) {
        return (ClientOptionsBase)super.setWriteIdleTimeout(idleTimeout);
    }

    @Override
    public ClientOptionsBase setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        return (ClientOptionsBase)super.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    @Override
    public ClientOptionsBase setSsl(boolean ssl) {
        return (ClientOptionsBase)super.setSsl(ssl);
    }

    @Override
    public ClientOptionsBase setKeyCertOptions(KeyCertOptions options) {
        return (ClientOptionsBase)super.setKeyCertOptions(options);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setKeyStoreOptions(JksOptions options) {
        return (ClientOptionsBase)super.setKeyStoreOptions(options);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setPfxKeyCertOptions(PfxOptions options) {
        return (ClientOptionsBase)super.setPfxKeyCertOptions(options);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setPemKeyCertOptions(PemKeyCertOptions options) {
        return (ClientOptionsBase)super.setPemKeyCertOptions(options);
    }

    @Override
    public ClientOptionsBase setTrustOptions(TrustOptions options) {
        return (ClientOptionsBase)super.setTrustOptions(options);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setTrustStoreOptions(JksOptions options) {
        return (ClientOptionsBase)super.setTrustStoreOptions(options);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setPfxTrustOptions(PfxOptions options) {
        return (ClientOptionsBase)super.setPfxTrustOptions(options);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setPemTrustOptions(PemTrustOptions options) {
        return (ClientOptionsBase)super.setPemTrustOptions(options);
    }

    @Override
    public ClientOptionsBase setUseAlpn(boolean useAlpn) {
        return (ClientOptionsBase)super.setUseAlpn(useAlpn);
    }

    @Override
    public ClientOptionsBase setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (ClientOptionsBase)super.setSslEngineOptions(sslEngineOptions);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (ClientOptionsBase)super.setJdkSslEngineOptions(sslEngineOptions);
    }

    @Override
    @Deprecated
    public ClientOptionsBase setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (ClientOptionsBase)super.setOpenSslEngineOptions(sslEngineOptions);
    }

    @Override
    public ClientOptionsBase setSendBufferSize(int sendBufferSize) {
        return (ClientOptionsBase)super.setSendBufferSize(sendBufferSize);
    }

    @Override
    public ClientOptionsBase setReceiveBufferSize(int receiveBufferSize) {
        return (ClientOptionsBase)super.setReceiveBufferSize(receiveBufferSize);
    }

    @Override
    public ClientOptionsBase setReuseAddress(boolean reuseAddress) {
        return (ClientOptionsBase)super.setReuseAddress(reuseAddress);
    }

    @Override
    public ClientOptionsBase setReusePort(boolean reusePort) {
        return (ClientOptionsBase)super.setReusePort(reusePort);
    }

    @Override
    public ClientOptionsBase setTrafficClass(int trafficClass) {
        return (ClientOptionsBase)super.setTrafficClass(trafficClass);
    }

    @Override
    public ClientOptionsBase addEnabledCipherSuite(String suite) {
        return (ClientOptionsBase)super.addEnabledCipherSuite(suite);
    }

    @Override
    public ClientOptionsBase removeEnabledCipherSuite(String suite) {
        return (ClientOptionsBase)super.removeEnabledCipherSuite(suite);
    }

    @Override
    public ClientOptionsBase addCrlPath(String crlPath) throws NullPointerException {
        return (ClientOptionsBase)super.addCrlPath(crlPath);
    }

    @Override
    public ClientOptionsBase addCrlValue(Buffer crlValue) throws NullPointerException {
        return (ClientOptionsBase)super.addCrlValue(crlValue);
    }

    @Override
    public ClientOptionsBase addEnabledSecureTransportProtocol(String protocol) {
        return (ClientOptionsBase)super.addEnabledSecureTransportProtocol(protocol);
    }

    @Override
    public ClientOptionsBase removeEnabledSecureTransportProtocol(String protocol) {
        return (ClientOptionsBase)super.removeEnabledSecureTransportProtocol(protocol);
    }

    @Override
    public ClientOptionsBase setTcpFastOpen(boolean tcpFastOpen) {
        return (ClientOptionsBase)super.setTcpFastOpen(tcpFastOpen);
    }

    @Override
    public ClientOptionsBase setTcpCork(boolean tcpCork) {
        return (ClientOptionsBase)super.setTcpCork(tcpCork);
    }

    @Override
    public ClientOptionsBase setTcpQuickAck(boolean tcpQuickAck) {
        return (ClientOptionsBase)super.setTcpQuickAck(tcpQuickAck);
    }

    @Override
    public ClientOptionsBase setTcpUserTimeout(int tcpUserTimeout) {
        return (ClientOptionsBase)super.setTcpUserTimeout(tcpUserTimeout);
    }
}

