/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net;

import com.arangodb.shaded.netty.handler.ssl.SslProvider;
import com.arangodb.shaded.vertx.codegen.annotations.DataObject;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.net.SSLEngineOptions;
import com.arangodb.shaded.vertx.core.spi.tls.DefaultSslContextFactory;
import com.arangodb.shaded.vertx.core.spi.tls.SslContextFactory;
import javax.net.ssl.SSLEngine;

@DataObject
public class JdkSSLEngineOptions
extends SSLEngineOptions {
    private static Boolean jdkAlpnAvailable;

    public static synchronized boolean isAlpnAvailable() {
        if (jdkAlpnAvailable == null) {
            boolean available = false;
            try {
                SSLEngine.class.getDeclaredMethod("getApplicationProtocol", new Class[0]);
                available = true;
            }
            catch (Exception ignore1) {
                try {
                    JdkSSLEngineOptions.class.getClassLoader().loadClass("sun.security.ssl.ALPNExtension");
                    available = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                jdkAlpnAvailable = available;
            }
        }
        return jdkAlpnAvailable;
    }

    public JdkSSLEngineOptions() {
    }

    public JdkSSLEngineOptions(JsonObject json) {
        super(json);
    }

    public JdkSSLEngineOptions(JdkSSLEngineOptions that) {
        super(that);
    }

    @Override
    public JdkSSLEngineOptions setUseWorkerThread(boolean useWorkerThread) {
        return (JdkSSLEngineOptions)super.setUseWorkerThread(useWorkerThread);
    }

    public JsonObject toJson() {
        return new JsonObject();
    }

    @Override
    public JdkSSLEngineOptions copy() {
        return new JdkSSLEngineOptions(this);
    }

    @Override
    public SslContextFactory sslContextFactory() {
        return new DefaultSslContextFactory(SslProvider.JDK, false);
    }
}

