/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net;

import com.arangodb.shaded.vertx.core.Vertx;
import com.arangodb.shaded.vertx.core.net.KeyCertOptions;
import com.arangodb.shaded.vertx.core.net.KeyManagerFactoryWrapper;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;

class KeyManagerFactoryOptions
implements KeyCertOptions {
    private final KeyManagerFactory keyManagerFactory;

    KeyManagerFactoryOptions(KeyManagerFactory keyManagerFactory) {
        if (keyManagerFactory == null || keyManagerFactory.getKeyManagers() == null || keyManagerFactory.getKeyManagers().length == 0) {
            throw new IllegalArgumentException("KeyManagerFactory is not present or is not initialized yet");
        }
        this.keyManagerFactory = keyManagerFactory;
    }

    KeyManagerFactoryOptions(X509KeyManager keyManager) {
        this(new KeyManagerFactoryWrapper(keyManager));
    }

    private KeyManagerFactoryOptions(KeyManagerFactoryOptions other) {
        this.keyManagerFactory = other.keyManagerFactory;
    }

    @Override
    public KeyCertOptions copy() {
        return new KeyManagerFactoryOptions(this);
    }

    @Override
    public KeyManagerFactory getKeyManagerFactory(Vertx vertx) {
        return this.keyManagerFactory;
    }

    @Override
    public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) {
        return this.keyManagerFactory.getKeyManagers()[0] instanceof X509KeyManager ? serverName -> (X509KeyManager)this.keyManagerFactory.getKeyManagers()[0] : null;
    }
}

