/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net.impl;

import com.arangodb.shaded.vertx.core.net.SocketAddress;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface ProxyFilter
extends Predicate<SocketAddress> {
    public static final ProxyFilter DEFAULT_PROXY_FILTER = so -> !so.isDomainSocket();

    public static ProxyFilter nonProxyHosts(List<String> nonProxyHosts) {
        List filterElts = nonProxyHosts.stream().map(nonProxyHost -> {
            if (nonProxyHost.contains("*")) {
                String pattern = nonProxyHost.replaceAll("\\.", "\\.").replaceAll("\\*", ".*");
                return Pattern.compile(pattern);
            }
            return nonProxyHost;
        }).collect(Collectors.toList());
        return so -> {
            if (so.isDomainSocket()) {
                return false;
            }
            String host = so.host();
            for (Object filterElt : filterElts) {
                if (!(filterElt instanceof Pattern ? ((Pattern)filterElt).matcher(host).matches() : filterElt.equals(host))) continue;
                return false;
            }
            return true;
        };
    }
}

