/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.net.impl;

import com.arangodb.shaded.netty.channel.ChannelHandlerContext;
import com.arangodb.shaded.netty.channel.ChannelInboundHandlerAdapter;
import com.arangodb.shaded.netty.handler.ssl.SniCompletionEvent;
import com.arangodb.shaded.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.arangodb.shaded.netty.util.Attribute;
import com.arangodb.shaded.netty.util.AttributeKey;
import com.arangodb.shaded.netty.util.concurrent.Promise;

public class SslHandshakeCompletionHandler
extends ChannelInboundHandlerAdapter {
    static AttributeKey<String> SERVER_NAME_ATTR = AttributeKey.valueOf("sniServerName");
    private final Promise<Void> promise;

    public SslHandshakeCompletionHandler(Promise<Void> promise) {
        this.promise = promise;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof SniCompletionEvent) {
            SniCompletionEvent completion = (SniCompletionEvent)evt;
            if (completion.isSuccess()) {
                Attribute<String> val = ctx.channel().attr(SERVER_NAME_ATTR);
                val.set(completion.hostname());
            } else {
                this.promise.tryFailure(completion.cause());
            }
        } else if (evt instanceof SslHandshakeCompletionEvent) {
            SslHandshakeCompletionEvent completion = (SslHandshakeCompletionEvent)evt;
            if (completion.isSuccess()) {
                ctx.pipeline().remove(this);
                this.promise.setSuccess(null);
            } else {
                this.promise.tryFailure(completion.cause());
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
    }
}

