/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.core.spi;

import com.arangodb.shaded.vertx.core.VertxOptions;
import com.arangodb.shaded.vertx.core.impl.VertxBuilder;
import com.arangodb.shaded.vertx.core.impl.launcher.commands.BareCommand;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.metrics.MetricsOptions;
import com.arangodb.shaded.vertx.core.spi.VertxServiceProvider;
import com.arangodb.shaded.vertx.core.spi.metrics.VertxMetrics;

public interface VertxMetricsFactory
extends VertxServiceProvider {
    @Override
    default public void init(VertxBuilder builder) {
        if (builder.metrics() == null) {
            MetricsOptions metricsOptions;
            JsonObject config = builder.config();
            VertxOptions options = builder.options();
            metricsOptions = config != null && config.containsKey("metricsOptions") ? this.newOptions(config.getJsonObject("metricsOptions")) : ((metricsOptions = options.getMetricsOptions()) == null ? this.newOptions() : this.newOptions(metricsOptions));
            BareCommand.configureFromSystemProperties(metricsOptions, "vertx.metrics.options.");
            builder.options().setMetricsOptions(metricsOptions);
            if (options.getMetricsOptions().isEnabled()) {
                builder.metrics(this.metrics(options));
            }
        }
    }

    public VertxMetrics metrics(VertxOptions var1);

    default public MetricsOptions newOptions() {
        return new MetricsOptions();
    }

    default public MetricsOptions newOptions(MetricsOptions options) {
        return this.newOptions(options.toJson());
    }

    default public MetricsOptions newOptions(JsonObject jsonObject) {
        return new MetricsOptions(jsonObject);
    }
}

