/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth.authentication;

import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.ext.auth.authentication.CredentialValidationException;

public interface Credentials {
    default public <V> void checkValid(V arg) throws CredentialValidationException {
    }

    public JsonObject toJson();

    default public Credentials applyHttpChallenge(String challenge, HttpMethod method, String uri, Integer nc, String cnonce) throws CredentialValidationException {
        if (challenge != null) {
            throw new CredentialValidationException("This implementation can't handle HTTP Authentication");
        }
        return this;
    }

    default public Credentials applyHttpChallenge(String challenge, HttpMethod method, String uri) throws CredentialValidationException {
        return this.applyHttpChallenge(challenge, method, uri, null, null);
    }

    default public Credentials applyHttpChallenge(String challenge) throws CredentialValidationException {
        return this.applyHttpChallenge(challenge, null, null, null, null);
    }

    default public String toHttpAuthorization() {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be converted to a HTTP Authorization");
    }
}

