/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth.authorization.impl;

import com.arangodb.shaded.vertx.ext.auth.User;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.AuthorizationContext;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorizations;
import com.arangodb.shaded.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.impl.VariableAwareExpression;
import java.util.Objects;

public class PermissionBasedAuthorizationImpl
implements PermissionBasedAuthorization {
    private final String permission;
    private VariableAwareExpression resource;

    public PermissionBasedAuthorizationImpl(String permission) {
        this.permission = Objects.requireNonNull(permission);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PermissionBasedAuthorizationImpl)) {
            return false;
        }
        PermissionBasedAuthorizationImpl other = (PermissionBasedAuthorizationImpl)obj;
        return Objects.equals(this.permission, other.permission) && Objects.equals(this.resource, other.resource);
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    public int hashCode() {
        return Objects.hash(this.permission, this.resource);
    }

    @Override
    public boolean match(AuthorizationContext context) {
        Objects.requireNonNull(context);
        User user = context.user();
        if (user != null) {
            PermissionBasedAuthorization resolvedAuthorization = this.getResolvedAuthorization(context);
            Authorizations authorizations = user.authorizations();
            for (String providerId : authorizations.getProviderIds()) {
                for (Authorization authorization : authorizations.get(providerId)) {
                    if (!authorization.verify(resolvedAuthorization)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private PermissionBasedAuthorization getResolvedAuthorization(AuthorizationContext context) {
        if (this.resource == null || !this.resource.hasVariable()) {
            return this;
        }
        return PermissionBasedAuthorization.create(this.permission).setResource(this.resource.resolve(context));
    }

    @Override
    public boolean verify(Authorization otherAuthorization) {
        WildcardPermissionBasedAuthorization otherWildcardPermissionBasedAuthorization;
        Objects.requireNonNull(otherAuthorization);
        if (otherAuthorization instanceof PermissionBasedAuthorization) {
            PermissionBasedAuthorization otherPermissionBasedAuthorization = (PermissionBasedAuthorization)otherAuthorization;
            if (this.permission.equals(otherPermissionBasedAuthorization.getPermission())) {
                if (this.getResource() == null) {
                    return otherPermissionBasedAuthorization.getResource() == null;
                }
                return this.getResource().equals(otherPermissionBasedAuthorization.getResource());
            }
        } else if (otherAuthorization instanceof WildcardPermissionBasedAuthorization && this.permission.equals((otherWildcardPermissionBasedAuthorization = (WildcardPermissionBasedAuthorization)otherAuthorization).getPermission())) {
            if (this.getResource() == null) {
                return otherWildcardPermissionBasedAuthorization.getResource() == null;
            }
            return this.getResource().equals(otherWildcardPermissionBasedAuthorization.getResource());
        }
        return false;
    }

    @Override
    public String getResource() {
        return this.resource != null ? this.resource.getValue() : null;
    }

    @Override
    public PermissionBasedAuthorization setResource(String resource) {
        Objects.requireNonNull(resource);
        this.resource = new VariableAwareExpression(resource);
        return this;
    }
}

