/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth.authorization.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class WildcardExpression {
    protected static final String PART_DIVIDER_TOKEN = ":";
    protected static final String SUBPART_DIVIDER_TOKEN = ",";
    protected static final String WILDCARD_TOKEN = "*";
    private List<Set<String>> parts;
    private final String value;

    public WildcardExpression(String value) {
        Objects.requireNonNull(value);
        this.value = value.trim();
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Wildcard value cannot be empty");
        }
        this.setParts(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WildcardExpression)) {
            return false;
        }
        WildcardExpression other = (WildcardExpression)obj;
        return Objects.equals(this.parts, other.parts);
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }

    public boolean implies(String p) {
        if (p == null) {
            return false;
        }
        if (this.value.equals(p)) {
            return true;
        }
        return this.implies(new WildcardExpression(p));
    }

    public boolean implies(WildcardExpression p) {
        if (p == null) {
            return false;
        }
        List<Set<String>> otherParts = p.parts;
        int i = 0;
        for (Set<String> otherPart : otherParts) {
            if (this.parts.size() - 1 < i) {
                return true;
            }
            Set<String> part = this.parts.get(i);
            if (!part.contains(WILDCARD_TOKEN) && !part.containsAll(otherPart)) {
                return false;
            }
            ++i;
        }
        while (i < this.parts.size()) {
            Set<String> part = this.parts.get(i);
            if (!part.contains(WILDCARD_TOKEN)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void setParts(String wildcardString) {
        if ((wildcardString = wildcardString.trim()).isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot be empty");
        }
        this.parts = new ArrayList<Set<String>>();
        for (String part : wildcardString.split(PART_DIVIDER_TOKEN)) {
            LinkedHashSet<String> subparts = new LinkedHashSet<String>(Arrays.asList(part.split(SUBPART_DIVIDER_TOKEN)));
            if (subparts.isEmpty()) {
                throw new IllegalArgumentException("Wildcard string cannot contain parts with only dividers. Make sure permission strings are properly formatted.");
            }
            this.parts.add(subparts);
        }
        if (this.parts.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot contain only dividers. Make sure permission strings are properly formatted.");
        }
    }

    public String toString() {
        return this.value;
    }
}

