/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth.impl;

import com.arangodb.shaded.vertx.core.json.JsonArray;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.ext.auth.User;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorizations;
import com.arangodb.shaded.vertx.ext.auth.authorization.impl.AuthorizationConverter;
import java.util.Objects;

public class UserConverter {
    private static final String FIELD_PRINCIPAL = "principal";
    private static final String FIELD_AUTHORIZATIONS = "authorizations";
    private static final String FIELD_ATTRIBUTES = "attributes";

    public static JsonObject encode(User value) throws IllegalArgumentException {
        Objects.requireNonNull(value);
        JsonObject json = new JsonObject();
        json.put(FIELD_PRINCIPAL, value.principal());
        Authorizations authorizations = value.authorizations();
        if (authorizations != null) {
            JsonObject jsonAuthorizations = new JsonObject();
            for (String providerId : authorizations.getProviderIds()) {
                JsonArray jsonAuthorizationByProvider = new JsonArray();
                jsonAuthorizations.put(providerId, jsonAuthorizationByProvider);
                for (Authorization authorization : authorizations.get(providerId)) {
                    jsonAuthorizationByProvider.add(AuthorizationConverter.encode(authorization));
                }
            }
            json.put(FIELD_AUTHORIZATIONS, jsonAuthorizations);
        }
        json.put(FIELD_ATTRIBUTES, value.attributes());
        return json;
    }

    public static User decode(JsonObject json) throws IllegalArgumentException {
        Objects.requireNonNull(json);
        JsonObject principal = json.getJsonObject(FIELD_PRINCIPAL);
        User user = User.create(principal);
        JsonObject jsonAuthorizations = json.getJsonObject(FIELD_AUTHORIZATIONS);
        for (String fieldName : jsonAuthorizations.fieldNames()) {
            JsonArray jsonAuthorizationByProvider = jsonAuthorizations.getJsonArray(fieldName);
            for (int i = 0; i < jsonAuthorizationByProvider.size(); ++i) {
                JsonObject jsonAuthorization = jsonAuthorizationByProvider.getJsonObject(i);
                user.authorizations().add(fieldName, AuthorizationConverter.decode(jsonAuthorization));
            }
        }
        user.attributes().mergeIn(json.getJsonObject(FIELD_ATTRIBUTES, new JsonObject()));
        return user;
    }
}

