/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth.impl;

import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.json.JsonArray;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.shareddata.ClusterSerializable;
import com.arangodb.shaded.vertx.ext.auth.AuthProvider;
import com.arangodb.shaded.vertx.ext.auth.User;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorization;
import com.arangodb.shaded.vertx.ext.auth.authorization.Authorizations;
import com.arangodb.shaded.vertx.ext.auth.authorization.impl.AuthorizationContextImpl;
import com.arangodb.shaded.vertx.ext.auth.authorization.impl.AuthorizationsImpl;
import com.arangodb.shaded.vertx.ext.auth.impl.UserConverter;
import java.util.Collections;
import java.util.Objects;

public class UserImpl
implements User,
ClusterSerializable {
    private Authorizations authorizations;
    private JsonObject attributes;
    private JsonObject principal;

    public UserImpl() {
    }

    public UserImpl(JsonObject principal, JsonObject attributes) {
        this.principal = Objects.requireNonNull(principal);
        this.attributes = attributes;
        this.authorizations = new AuthorizationsImpl();
    }

    @Override
    public Authorizations authorizations() {
        return this.authorizations;
    }

    @Override
    public JsonObject attributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserImpl other = (UserImpl)obj;
        return Objects.equals(this.authorizations, other.authorizations) && Objects.equals(this.principal, other.principal) && Objects.equals(this.attributes, other.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.authorizations, this.principal, this.attributes);
    }

    @Override
    public User isAuthorized(Authorization authorization, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(authorization);
        Objects.requireNonNull(resultHandler);
        AuthorizationContextImpl context = new AuthorizationContextImpl(this);
        resultHandler.handle(Future.succeededFuture(authorization.match(context)));
        return this;
    }

    @Override
    public JsonObject principal() {
        return this.principal;
    }

    @Override
    public void setAuthProvider(AuthProvider authProvider) {
    }

    @Override
    public User merge(User other) {
        if (other == null) {
            return this;
        }
        JsonArray amr = this.principal().getJsonArray("amr");
        JsonArray otherAmr = other.principal().getJsonArray("amr");
        this.principal().mergeIn(other.principal());
        if (amr == null) {
            if (otherAmr != null) {
                amr = otherAmr.copy();
            }
        } else if (otherAmr != null) {
            amr = amr.copy();
            for (Object el : otherAmr) {
                if (amr.contains(el)) continue;
                amr.add(el);
            }
        }
        if (amr == null) {
            this.principal.put("amr", Collections.singletonList("mfa"));
        } else {
            if (!(amr = amr.copy()).contains("mfa")) {
                amr.add("mfa");
            }
            this.principal.put("amr", amr);
        }
        JsonObject attrs = this.attributes();
        JsonObject otherAttrs = other.attributes();
        if (attrs == null) {
            if (otherAttrs != null) {
                this.attributes = otherAttrs.copy();
            }
        } else if (otherAttrs != null) {
            for (String key : otherAttrs.fieldNames()) {
                Object lhsValue = attrs.getValue(key);
                Object rhsValue = otherAttrs.getValue(key);
                if (lhsValue == null) {
                    attrs.put(key, rhsValue instanceof JsonArray ? new JsonArray().add(rhsValue) : rhsValue);
                    continue;
                }
                if (lhsValue instanceof JsonArray) {
                    if (rhsValue instanceof JsonArray) {
                        ((JsonArray)lhsValue).addAll((JsonArray)rhsValue);
                        continue;
                    }
                    ((JsonArray)lhsValue).add(rhsValue);
                    continue;
                }
                if (rhsValue instanceof JsonArray) {
                    attrs.put(key, new JsonArray().add(lhsValue).addAll((JsonArray)rhsValue));
                    continue;
                }
                attrs.put(key, new JsonArray().add(lhsValue).add(rhsValue));
            }
        }
        return this;
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        UserConverter.encode(this).writeToBuffer(buffer);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        JsonObject jsonObject = new JsonObject();
        int read = jsonObject.readFromBuffer(pos, buffer);
        User readUser = UserConverter.decode(jsonObject);
        this.principal = readUser.principal();
        this.authorizations = readUser.authorizations();
        this.attributes = readUser.attributes();
        return read;
    }
}

