/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.auth.impl.asn;

import com.arangodb.shaded.vertx.core.buffer.Buffer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ASN1 {
    public static final int ANY = 0;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int REAL = 9;
    public static final int ENUMERATED = 10;
    public static final int UTF8_STRING = 12;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int NUMERIC_STRING = 18;
    public static final int PRINTABLE_STRING = 19;
    public static final int VIDEOTEX_STRING = 21;
    public static final int IA5_STRING = 22;
    public static final int UTC_TIME = 23;
    public static final int GRAPHIC_STRING = 25;
    public static final int ISO646_STRING = 26;
    public static final int GENERAL_STRING = 27;
    public static final int UNIVERSAL_STRING = 28;
    public static final int BMP_STRING = 30;
    public static final int CONSTRUCTED = 32;
    public static final int CONTEXT_SPECIFIC = 128;
    private static final int CLASS_MASK = 192;
    private static final int CONSTRUCTED_MASK = 32;
    private static final int NUMBER_MASK = 31;
    private static final int LEADING_BIT_MASK = 128;

    public static byte[] length(int x) {
        if (x <= 127) {
            return new byte[]{(byte)x};
        }
        if (x < 256) {
            return new byte[]{-127, (byte)x};
        }
        throw new IllegalArgumentException("length >= 256");
    }

    public static byte[] sequence(byte[] data) {
        int sequenceTag = 48;
        return Buffer.buffer().appendByte((byte)48).appendBytes(ASN1.length(data.length)).appendBytes(data).getBytes();
    }

    public static ASN parseASN1(byte[] buffer) {
        return ASN1.parseASN1(Buffer.buffer(buffer), 0);
    }

    public static ASN parseASN1(Buffer buffer) {
        return ASN1.parseASN1(buffer, 0);
    }

    public static ASN parseASN1(Buffer buffer, int startPos) {
        ASNTag tag = ASN1.readTag(buffer, startPos);
        ASNLength length = ASN1.readLength(buffer, tag.nextPos);
        List<Object> value = ASN1.readValue(buffer, length.nextPos, tag, length);
        return new ASN(tag, length, value);
    }

    private static ASNTag readTag(Buffer buffer, int startPos) {
        short firstByte;
        int pos = startPos;
        boolean tagConstructed = ((firstByte = buffer.getUnsignedByte(pos++)) & 0x20) > 0;
        int tagNumber = 0;
        if ((firstByte & 0x1F) != 31) {
            tagNumber = firstByte & 0x1F;
        } else {
            short octet;
            do {
                octet = buffer.getUnsignedByte(pos++);
                tagNumber = tagNumber * 128 + (octet & 0xFFFFFF7F);
            } while ((octet & 0x80) != 0);
        }
        return new ASNTag(firstByte, tagConstructed, tagNumber, pos);
    }

    private static ASNLength readLength(Buffer buffer, int startPos) {
        short firstByte;
        int pos = startPos;
        boolean longForm = ((firstByte = buffer.getUnsignedByte(pos++)) & 0x80) != 0;
        int contentLength = 0;
        if (!longForm) {
            contentLength = firstByte & 0xFFFFFF7F;
        } else {
            int lengthOctets = firstByte & 0xFFFFFF7F;
            while (pos <= startPos + lengthOctets) {
                contentLength = contentLength * 256 + buffer.getUnsignedByte(pos++);
            }
        }
        return new ASNLength(longForm && contentLength == 0, contentLength, pos);
    }

    private static List<Object> readValue(Buffer buffer, int startPos, ASNTag tagObj, ASNLength lengthObj) {
        ArrayList<Object> res = new ArrayList<Object>();
        int pos = startPos;
        if (!tagObj.constructed) {
            res.add(buffer.getBytes(pos, startPos + lengthObj.contentLength));
        } else {
            while (pos < startPos + lengthObj.contentLength) {
                ASN newObj = ASN1.parseASN1(buffer, pos);
                pos = newObj.length.nextPos + newObj.length.contentLength;
                if (newObj.tag.type == 0 && !newObj.tag.constructed && newObj.tag.number == 0 && newObj.length.contentLength == 0) break;
                res.add(newObj);
            }
        }
        return res;
    }

    public static class ASNLength {
        public final boolean indefinite;
        public final int contentLength;
        private final int nextPos;

        private ASNLength(boolean indefinite, int contentLength, int nextPos) {
            this.indefinite = indefinite;
            this.contentLength = contentLength;
            this.nextPos = nextPos;
        }
    }

    public static class ASNTag {
        public final int type;
        public final boolean constructed;
        public final int number;
        private final int nextPos;

        private ASNTag(int type, boolean constructed, int number, int nextPos) {
            this.type = type;
            this.constructed = constructed;
            this.number = number;
            this.nextPos = nextPos;
        }
    }

    public static class ASN {
        public final ASNTag tag;
        public final List<Object> value;
        public final ASNLength length;

        private ASN(ASNTag tag, ASNLength length, List<Object> value) {
            this.tag = tag;
            this.length = length;
            this.value = value;
        }

        public byte[] binary(int index) {
            return (byte[])this.value.get(index);
        }

        public int integer(int index) {
            byte[] bytes = this.binary(index);
            if (bytes.length > 4) {
                throw new IllegalArgumentException("integer too long");
            }
            int result = 0;
            for (byte b : bytes) {
                result = result << 8 | b & 0xFF;
            }
            return result;
        }

        public BigInteger bigInteger(int index) {
            return new BigInteger(this.binary(index));
        }

        public ASN object(int index) {
            return (ASN)this.value.get(index);
        }

        public ASN object(int index, int type) {
            ASN object = (ASN)this.value.get(index);
            if (!object.is(type)) {
                throw new ClassCastException("Object at index(" + index + ") is not of type: " + type);
            }
            return object;
        }

        public String oid(int index) {
            byte[] bytes = this.object(index, 6).binary(0);
            StringBuilder oid = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                int uint8 = Byte.toUnsignedInt(bytes[i]);
                if (i == 0) {
                    int b = uint8 % 40;
                    int a = (uint8 - b) / 40;
                    oid.append(a).append('.').append(b);
                    continue;
                }
                if (uint8 < 128) {
                    oid.append('.').append(uint8);
                    continue;
                }
                oid.append('.').append((uint8 - 128) * 128 + Byte.toUnsignedInt(bytes[i + 1]));
                ++i;
            }
            return oid.toString();
        }

        public int length() {
            return this.value.size();
        }

        public boolean is(int number) {
            if (this.tag.constructed) {
                return this.tag.type == 32 + number;
            }
            return this.tag.type == number;
        }
    }
}

