/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.web.client;

import com.arangodb.shaded.vertx.codegen.annotations.CacheReturn;
import com.arangodb.shaded.vertx.codegen.annotations.Fluent;
import com.arangodb.shaded.vertx.codegen.annotations.GenIgnore;
import com.arangodb.shaded.vertx.codegen.annotations.Nullable;
import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.AsyncResult;
import com.arangodb.shaded.vertx.core.Future;
import com.arangodb.shaded.vertx.core.Handler;
import com.arangodb.shaded.vertx.core.MultiMap;
import com.arangodb.shaded.vertx.core.Promise;
import com.arangodb.shaded.vertx.core.buffer.Buffer;
import com.arangodb.shaded.vertx.core.http.HttpMethod;
import com.arangodb.shaded.vertx.core.json.JsonObject;
import com.arangodb.shaded.vertx.core.net.ProxyOptions;
import com.arangodb.shaded.vertx.core.streams.ReadStream;
import com.arangodb.shaded.vertx.ext.auth.authentication.Credentials;
import com.arangodb.shaded.vertx.ext.auth.authentication.TokenCredentials;
import com.arangodb.shaded.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import com.arangodb.shaded.vertx.ext.web.client.HttpResponse;
import com.arangodb.shaded.vertx.ext.web.client.predicate.ResponsePredicate;
import com.arangodb.shaded.vertx.ext.web.client.predicate.ResponsePredicateResult;
import com.arangodb.shaded.vertx.ext.web.codec.BodyCodec;
import com.arangodb.shaded.vertx.ext.web.multipart.MultipartForm;
import com.arangodb.shaded.vertx.uritemplate.Variables;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@VertxGen
public interface HttpRequest<T> {
    @Fluent
    public HttpRequest<T> method(HttpMethod var1);

    public HttpMethod method();

    @Fluent
    public HttpRequest<T> port(int var1);

    public int port();

    public <U> HttpRequest<U> as(BodyCodec<U> var1);

    public BodyCodec<T> bodyCodec();

    @Fluent
    public HttpRequest<T> host(String var1);

    public String host();

    @Fluent
    public HttpRequest<T> virtualHost(String var1);

    public String virtualHost();

    @Fluent
    public HttpRequest<T> uri(String var1);

    public String uri();

    @Fluent
    public HttpRequest<T> putHeaders(MultiMap var1);

    @Fluent
    public HttpRequest<T> putHeader(String var1, String var2);

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public HttpRequest<T> putHeader(String var1, Iterable<String> var2);

    @CacheReturn
    public MultiMap headers();

    @Fluent
    @GenIgnore(value={"permitted-type"})
    public HttpRequest<T> authentication(Credentials var1);

    @Fluent
    default public HttpRequest<T> basicAuthentication(String id, String password) {
        return this.authentication(new UsernamePasswordCredentials(id, password).applyHttpChallenge(null));
    }

    @Fluent
    default public HttpRequest<T> basicAuthentication(Buffer id, Buffer password) {
        return this.basicAuthentication(id.toString(), password.toString());
    }

    @Fluent
    default public HttpRequest<T> bearerTokenAuthentication(String bearerToken) {
        return this.authentication(new TokenCredentials(bearerToken).applyHttpChallenge(null));
    }

    @Fluent
    public HttpRequest<T> ssl(Boolean var1);

    public Boolean ssl();

    @Fluent
    public HttpRequest<T> timeout(long var1);

    public long timeout();

    @Fluent
    public HttpRequest<T> idleTimeout(long var1);

    public long idleTimeout();

    @Fluent
    public HttpRequest<T> connectTimeout(long var1);

    public long connectTimeout();

    @Fluent
    public HttpRequest<T> addQueryParam(String var1, String var2);

    @Fluent
    public HttpRequest<T> setQueryParam(String var1, String var2);

    @Fluent
    public HttpRequest<T> setTemplateParam(String var1, String var2);

    @Fluent
    public HttpRequest<T> setTemplateParam(String var1, List<String> var2);

    @Fluent
    public HttpRequest<T> setTemplateParam(String var1, Map<String, String> var2);

    @Fluent
    public HttpRequest<T> followRedirects(boolean var1);

    public boolean followRedirects();

    @Fluent
    public HttpRequest<T> proxy(ProxyOptions var1);

    public ProxyOptions proxy();

    @Fluent
    default public HttpRequest<T> expect(Function<HttpResponse<Void>, ResponsePredicateResult> predicate) {
        return this.expect(predicate::apply);
    }

    @Fluent
    public HttpRequest<T> expect(ResponsePredicate var1);

    public List<ResponsePredicate> expectations();

    public MultiMap queryParams();

    public Variables templateParams();

    public HttpRequest<T> copy();

    @Fluent
    public HttpRequest<T> multipartMixed(boolean var1);

    public boolean multipartMixed();

    @Fluent
    public HttpRequest<T> traceOperation(String var1);

    public String traceOperation();

    public void sendStream(ReadStream<Buffer> var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendStream(ReadStream<Buffer> body) {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.sendStream(body, promise);
        return promise.future();
    }

    public void sendBuffer(Buffer var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendBuffer(Buffer body) {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.sendBuffer(body, promise);
        return promise.future();
    }

    public void sendJsonObject(JsonObject var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendJsonObject(JsonObject body) {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.sendJsonObject(body, promise);
        return promise.future();
    }

    public void sendJson(@Nullable Object var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendJson(@Nullable Object body) {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.sendJson(body, promise);
        return promise.future();
    }

    public void sendForm(MultiMap var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendForm(MultiMap body) {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.sendForm(body, promise);
        return promise.future();
    }

    public void sendForm(MultiMap var1, String var2, Handler<AsyncResult<HttpResponse<T>>> var3);

    default public Future<HttpResponse<T>> sendForm(MultiMap body, String charset) {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.sendForm(body, charset, promise);
        return promise.future();
    }

    public void sendMultipartForm(MultipartForm var1, Handler<AsyncResult<HttpResponse<T>>> var2);

    default public Future<HttpResponse<T>> sendMultipartForm(MultipartForm body) {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.sendMultipartForm(body, promise);
        return promise.future();
    }

    public void send(Handler<AsyncResult<HttpResponse<T>>> var1);

    default public Future<HttpResponse<T>> send() {
        Promise<HttpResponse<T>> promise = Promise.promise();
        this.send(promise);
        return promise.future();
    }
}

