/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.shaded.vertx.ext.web.client.predicate;

import com.arangodb.shaded.vertx.codegen.annotations.VertxGen;
import com.arangodb.shaded.vertx.core.http.HttpHeaders;
import com.arangodb.shaded.vertx.ext.web.client.HttpResponse;
import com.arangodb.shaded.vertx.ext.web.client.impl.predicate.ResponsePredicateImpl;
import com.arangodb.shaded.vertx.ext.web.client.predicate.ErrorConverter;
import com.arangodb.shaded.vertx.ext.web.client.predicate.ResponsePredicateResult;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface ResponsePredicate
extends Function<HttpResponse<Void>, ResponsePredicateResult> {
    public static final ResponsePredicate SC_INFORMATIONAL_RESPONSE = ResponsePredicate.status(100, 200);
    public static final ResponsePredicate SC_CONTINUE = ResponsePredicate.status(100);
    public static final ResponsePredicate SC_SWITCHING_PROTOCOLS = ResponsePredicate.status(101);
    public static final ResponsePredicate SC_PROCESSING = ResponsePredicate.status(102);
    public static final ResponsePredicate SC_EARLY_HINTS = ResponsePredicate.status(103);
    public static final ResponsePredicate SC_SUCCESS = ResponsePredicate.status(200, 300);
    public static final ResponsePredicate SC_OK = ResponsePredicate.status(200);
    public static final ResponsePredicate SC_CREATED = ResponsePredicate.status(201);
    public static final ResponsePredicate SC_ACCEPTED = ResponsePredicate.status(202);
    public static final ResponsePredicate SC_NON_AUTHORITATIVE_INFORMATION = ResponsePredicate.status(203);
    public static final ResponsePredicate SC_NO_CONTENT = ResponsePredicate.status(204);
    public static final ResponsePredicate SC_RESET_CONTENT = ResponsePredicate.status(205);
    public static final ResponsePredicate SC_PARTIAL_CONTENT = ResponsePredicate.status(206);
    public static final ResponsePredicate SC_MULTI_STATUS = ResponsePredicate.status(207);
    public static final ResponsePredicate SC_REDIRECTION = ResponsePredicate.status(300, 400);
    public static final ResponsePredicate SC_MULTIPLE_CHOICES = ResponsePredicate.status(300);
    public static final ResponsePredicate SC_MOVED_PERMANENTLY = ResponsePredicate.status(301);
    public static final ResponsePredicate SC_FOUND = ResponsePredicate.status(302);
    public static final ResponsePredicate SC_SEE_OTHER = ResponsePredicate.status(303);
    public static final ResponsePredicate SC_NOT_MODIFIED = ResponsePredicate.status(304);
    public static final ResponsePredicate SC_USE_PROXY = ResponsePredicate.status(305);
    public static final ResponsePredicate SC_TEMPORARY_REDIRECT = ResponsePredicate.status(307);
    public static final ResponsePredicate SC_PERMANENT_REDIRECT = ResponsePredicate.status(308);
    public static final ResponsePredicate SC_CLIENT_ERRORS = ResponsePredicate.status(400, 500);
    public static final ResponsePredicate SC_BAD_REQUEST = ResponsePredicate.status(400);
    public static final ResponsePredicate SC_UNAUTHORIZED = ResponsePredicate.status(401);
    public static final ResponsePredicate SC_PAYMENT_REQUIRED = ResponsePredicate.status(402);
    public static final ResponsePredicate SC_FORBIDDEN = ResponsePredicate.status(403);
    public static final ResponsePredicate SC_NOT_FOUND = ResponsePredicate.status(404);
    public static final ResponsePredicate SC_METHOD_NOT_ALLOWED = ResponsePredicate.status(405);
    public static final ResponsePredicate SC_NOT_ACCEPTABLE = ResponsePredicate.status(406);
    public static final ResponsePredicate SC_PROXY_AUTHENTICATION_REQUIRED = ResponsePredicate.status(407);
    public static final ResponsePredicate SC_REQUEST_TIMEOUT = ResponsePredicate.status(408);
    public static final ResponsePredicate SC_CONFLICT = ResponsePredicate.status(409);
    public static final ResponsePredicate SC_GONE = ResponsePredicate.status(410);
    public static final ResponsePredicate SC_LENGTH_REQUIRED = ResponsePredicate.status(411);
    public static final ResponsePredicate SC_PRECONDITION_FAILED = ResponsePredicate.status(412);
    public static final ResponsePredicate SC_REQUEST_ENTITY_TOO_LARGE = ResponsePredicate.status(413);
    public static final ResponsePredicate SC_REQUEST_URI_TOO_LONG = ResponsePredicate.status(414);
    public static final ResponsePredicate SC_UNSUPPORTED_MEDIA_TYPE = ResponsePredicate.status(415);
    public static final ResponsePredicate SC_REQUESTED_RANGE_NOT_SATISFIABLE = ResponsePredicate.status(416);
    public static final ResponsePredicate SC_EXPECTATION_FAILED = ResponsePredicate.status(417);
    public static final ResponsePredicate SC_MISDIRECTED_REQUEST = ResponsePredicate.status(421);
    public static final ResponsePredicate SC_UNPROCESSABLE_ENTITY = ResponsePredicate.status(422);
    public static final ResponsePredicate SC_LOCKED = ResponsePredicate.status(423);
    public static final ResponsePredicate SC_FAILED_DEPENDENCY = ResponsePredicate.status(424);
    public static final ResponsePredicate SC_UNORDERED_COLLECTION = ResponsePredicate.status(425);
    public static final ResponsePredicate SC_UPGRADE_REQUIRED = ResponsePredicate.status(426);
    public static final ResponsePredicate SC_PRECONDITION_REQUIRED = ResponsePredicate.status(428);
    public static final ResponsePredicate SC_TOO_MANY_REQUESTS = ResponsePredicate.status(429);
    public static final ResponsePredicate SC_REQUEST_HEADER_FIELDS_TOO_LARGE = ResponsePredicate.status(431);
    public static final ResponsePredicate SC_SERVER_ERRORS = ResponsePredicate.status(500, 600);
    public static final ResponsePredicate SC_INTERNAL_SERVER_ERROR = ResponsePredicate.status(500);
    public static final ResponsePredicate SC_NOT_IMPLEMENTED = ResponsePredicate.status(501);
    public static final ResponsePredicate SC_BAD_GATEWAY = ResponsePredicate.status(502);
    public static final ResponsePredicate SC_SERVICE_UNAVAILABLE = ResponsePredicate.status(503);
    public static final ResponsePredicate SC_GATEWAY_TIMEOUT = ResponsePredicate.status(504);
    public static final ResponsePredicate SC_HTTP_VERSION_NOT_SUPPORTED = ResponsePredicate.status(505);
    public static final ResponsePredicate SC_VARIANT_ALSO_NEGOTIATES = ResponsePredicate.status(506);
    public static final ResponsePredicate SC_INSUFFICIENT_STORAGE = ResponsePredicate.status(507);
    public static final ResponsePredicate SC_NOT_EXTENDED = ResponsePredicate.status(510);
    public static final ResponsePredicate SC_NETWORK_AUTHENTICATION_REQUIRED = ResponsePredicate.status(511);
    public static final ResponsePredicate JSON = ResponsePredicate.contentType("application/json");

    public static ResponsePredicate status(int statusCode) {
        return ResponsePredicate.status(statusCode, statusCode + 1);
    }

    public static ResponsePredicate status(int min, int max) {
        return response -> {
            int sc = response.statusCode();
            if (sc >= min && sc < max) {
                return ResponsePredicateResult.success();
            }
            if (max - min == 1) {
                return ResponsePredicateResult.failure("Response status code " + sc + " is not equal to " + min);
            }
            return ResponsePredicateResult.failure("Response status code " + sc + " is not between " + min + " and " + max);
        };
    }

    public static ResponsePredicate contentType(String mimeType) {
        return ResponsePredicate.contentType(Collections.singletonList(mimeType));
    }

    public static ResponsePredicate contentType(List<String> mimeTypes) {
        return response -> {
            String contentType = response.headers().get(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                return ResponsePredicateResult.failure("Missing response content type");
            }
            int paramIdx = contentType.indexOf(59);
            String mediaType = paramIdx != -1 ? contentType.substring(0, paramIdx) : contentType;
            for (String mimeType : mimeTypes) {
                if (!mediaType.equalsIgnoreCase(mimeType)) continue;
                return ResponsePredicateResult.success();
            }
            StringBuilder sb = new StringBuilder("Expect content type ").append(contentType).append(" to be one of ");
            boolean first = true;
            for (String mimeType : mimeTypes) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(mimeType);
            }
            return ResponsePredicateResult.failure(sb.toString());
        };
    }

    public static ResponsePredicate create(Function<HttpResponse<Void>, ResponsePredicateResult> test) {
        return test::apply;
    }

    public static ResponsePredicate create(Function<HttpResponse<Void>, ResponsePredicateResult> test, ErrorConverter errorConverter) {
        return new ResponsePredicateImpl(test, errorConverter);
    }

    default public ErrorConverter errorConverter() {
        return ErrorConverter.DEFAULT_CONVERTER;
    }
}

