/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.velocypack.internal.util;

import com.arangodb.velocypack.internal.util.NumberUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class DateUtil {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneOffset.UTC);

    private DateUtil() {
    }

    public static Date toDate(byte[] array, int offset, int length) {
        long milliseconds = NumberUtil.toLong(array, offset, length);
        return new Date(milliseconds);
    }

    public static java.sql.Date toSQLDate(byte[] array, int offset, int length) {
        long milliseconds = NumberUtil.toLong(array, offset, length);
        return new java.sql.Date(milliseconds);
    }

    public static Timestamp toSQLTimestamp(byte[] array, int offset, int length) {
        long milliseconds = NumberUtil.toLong(array, offset, length);
        return new Timestamp(milliseconds);
    }

    public static Date parse(String source) throws ParseException {
        try {
            return new Date(ZonedDateTime.parse(source).toInstant().toEpochMilli());
        }
        catch (DateTimeParseException e) {
            throw new ParseException("Unparseable date: \"" + e.getParsedString() + "\"", e.getErrorIndex());
        }
    }

    public static String format(Date date) {
        return DATE_FORMATTER.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneOffset.UTC));
    }
}

