/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.vst;

import com.arangodb.ArangoDBException;
import com.arangodb.arch.UnstableApi;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.net.Communication;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.util.ResponseUtils;
import com.arangodb.vst.internal.AuthenticationRequest;
import com.arangodb.vst.internal.JwtAuthenticationRequest;
import com.arangodb.vst.internal.VstConnectionAsync;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

@UnstableApi
public final class VstCommunication
extends Communication {
    private static final String ENCRYPTION_PLAIN = "plain";
    private static final String ENCRYPTION_JWT = "jwt";
    private final String user;
    private final String password;
    private volatile String jwt;

    public VstCommunication(@UnstableApi ArangoConfig config, @UnstableApi HostHandler hostHandler) {
        super(config, hostHandler);
        this.user = config.getUser();
        this.password = config.getPassword();
        this.jwt = config.getJwt();
    }

    @Override
    protected void connect(@UnstableApi Connection conn) throws IOException {
        VstConnectionAsync connection = (VstConnectionAsync)conn;
        if (!connection.isOpen()) {
            connection.open();
            if (this.jwt != null || this.user != null) {
                this.tryAuthenticate(connection);
            }
        }
    }

    private void tryAuthenticate(VstConnectionAsync connection) throws IOException {
        try {
            this.authenticate(connection);
        }
        catch (ArangoDBException authException) {
            connection.close();
            throw authException;
        }
    }

    private void authenticate(VstConnectionAsync connection) throws IOException {
        InternalResponse response;
        InternalRequest authRequest = this.jwt != null ? new JwtAuthenticationRequest(this.jwt, ENCRYPTION_JWT) : new AuthenticationRequest(this.user, this.password != null ? this.password : "", ENCRYPTION_PLAIN);
        try {
            response = connection.executeAsync(authRequest).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ArangoDBException.of(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        this.checkError(response);
    }

    private void checkError(InternalResponse response) {
        ArangoDBException e = ResponseUtils.translateError(this.serde, response);
        if (e != null) {
            throw e;
        }
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }
}

