/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.vst;

import com.arangodb.ArangoDBException;
import com.arangodb.arch.UnstableApi;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.vst.VstCommunication;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@UnstableApi
public class VstProtocol
implements CommunicationProtocol {
    private final VstCommunication communication;
    private final ExecutorService outgoingExecutor = Executors.newCachedThreadPool();

    public VstProtocol(VstCommunication communication) {
        this.communication = communication;
    }

    @Override
    @UnstableApi
    public CompletableFuture<InternalResponse> executeAsync(@UnstableApi InternalRequest request, @UnstableApi HostHandle hostHandle) {
        if (this.outgoingExecutor.isShutdown()) {
            CompletableFuture<InternalResponse> cf = new CompletableFuture<InternalResponse>();
            cf.completeExceptionally(new ArangoDBException("VstProtocol already closed!"));
            return cf;
        }
        return CompletableFuture.completedFuture(null).thenComposeAsync(__ -> this.communication.executeAsync(request, hostHandle), (Executor)this.outgoingExecutor);
    }

    @Override
    public void setJwt(String jwt) {
        this.communication.setJwt(jwt);
    }

    @Override
    public void close() throws IOException {
        this.outgoingExecutor.shutdown();
        this.communication.close();
    }
}

