/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.vst.internal;

import com.arangodb.vst.internal.Chunk;
import com.arangodb.vst.internal.Message;
import com.arangodb.vst.internal.MessageStore;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class ChunkStore {
    private final MessageStore messageStore;
    private final Map<Long, ByteBuffer> data;

    public ChunkStore(MessageStore messageStore) {
        this.messageStore = messageStore;
        this.data = new HashMap<Long, ByteBuffer>();
    }

    public ByteBuffer storeChunk(Chunk chunk) throws BufferUnderflowException, IndexOutOfBoundsException {
        long messageId = chunk.getMessageId();
        ByteBuffer chunkBuffer = this.data.get(messageId);
        if (chunkBuffer == null) {
            if (!chunk.isFirstChunk()) {
                this.messageStore.cancel(messageId);
                return null;
            }
            int length = (int)(chunk.getMessageLength() > 0L ? chunk.getMessageLength() : (long)chunk.getContentLength());
            chunkBuffer = ByteBuffer.allocate(length);
            this.data.put(messageId, chunkBuffer);
        }
        return chunkBuffer;
    }

    public void checkCompleteness(long messageId) {
        this.checkCompleteness(messageId, this.data.get(messageId));
    }

    private void checkCompleteness(long messageId, ByteBuffer chunkBuffer) throws BufferUnderflowException, IndexOutOfBoundsException {
        if (chunkBuffer.position() == chunkBuffer.limit()) {
            this.messageStore.consume(new Message(messageId, chunkBuffer.array()));
            this.data.remove(messageId);
        }
    }
}

