/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.vst.internal;

import com.arangodb.PackageVersion;
import com.arangodb.config.HostDescription;
import com.arangodb.internal.InternalRequest;
import com.arangodb.internal.InternalResponse;
import com.arangodb.internal.config.ArangoConfig;
import com.arangodb.internal.serde.InternalSerde;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackParserException;
import com.arangodb.vst.internal.Chunk;
import com.arangodb.vst.internal.Message;
import com.arangodb.vst.internal.VstConnection;
import com.arangodb.vst.internal.utils.CompletableFutureUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VstConnectionAsync
extends VstConnection<CompletableFuture<Message>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VstConnectionAsync.class);
    private static final AtomicLong mId = new AtomicLong(0L);
    private static final String X_ARANGO_DRIVER = "JavaDriver/" + PackageVersion.VERSION + " (JVM/" + System.getProperty("java.specification.version") + ")";
    private final Integer chunkSize;
    private final InternalSerde serde;

    public VstConnectionAsync(ArangoConfig config, HostDescription host) {
        super(config, host);
        this.chunkSize = config.getChunkSize();
        this.serde = config.getInternalSerde();
    }

    @Override
    public synchronized CompletableFuture<Message> write(Message message, Collection<Chunk> chunks) {
        CompletableFuture<Message> future = new CompletableFuture<Message>();
        FutureTask<Message> task = new FutureTask<Message>(() -> {
            try {
                future.complete(this.messageStore.get(message.getId()));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return null;
        });
        this.messageStore.storeMessage(message.getId(), task);
        super.writeIntern(message, chunks);
        if (this.timeout == null || (long)this.timeout.intValue() == 0L) {
            return future;
        }
        return CompletableFutureUtils.orTimeout(future, this.timeout.intValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doKeepAlive() {
        ((CompletableFuture)this.sendKeepAlive()).join();
    }

    @Override
    public CompletableFuture<InternalResponse> executeAsync(InternalRequest request) {
        CompletableFuture<InternalResponse> rfuture = new CompletableFuture<InternalResponse>();
        try {
            Message message = this.createMessage(request);
            this.send(message).whenComplete((m, ex) -> {
                if (m != null) {
                    InternalResponse response;
                    try {
                        response = this.createResponse((Message)m);
                    }
                    catch (Exception e) {
                        rfuture.completeExceptionally(e);
                        return;
                    }
                    rfuture.complete(response);
                } else {
                    Throwable e = ex instanceof CompletionException ? ex.getCause() : ex;
                    rfuture.completeExceptionally(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            rfuture.completeExceptionally(e);
        }
        return rfuture;
    }

    private Message createMessage(InternalRequest request) throws VPackParserException {
        request.putHeaderParam("accept", "application/x-velocypack");
        request.putHeaderParam("content-type", "application/x-velocypack");
        request.putHeaderParam("x-arango-driver", X_ARANGO_DRIVER);
        long id = mId.incrementAndGet();
        return new Message(id, this.serde.serialize(request), request.getBody());
    }

    private CompletableFuture<Message> send(Message message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Send Message (id=%s, head=%s, body=%s)", message.getId(), this.serde.toJsonString(message.getHead().toByteArray()), message.getBody() != null ? this.serde.toJsonString(message.getBody().toByteArray()) : "{}"));
        }
        return this.write(message, (Collection)this.buildChunks(message));
    }

    private Collection<Chunk> buildChunks(Message message) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        VPackSlice head = message.getHead();
        int size = head.getByteSize();
        VPackSlice body = message.getBody();
        if (body != null) {
            size += body.getByteSize();
        }
        int n = size / this.chunkSize;
        int numberOfChunks = size % this.chunkSize != 0 ? n + 1 : n;
        int off = 0;
        int i = 0;
        while (size > 0) {
            int len = Math.min(this.chunkSize, size);
            long messageLength = i == 0 && numberOfChunks > 1 ? (long)size : -1L;
            Chunk chunk = new Chunk(message.getId(), i, numberOfChunks, messageLength, off, len);
            size -= len;
            off += len;
            chunks.add(chunk);
            ++i;
        }
        return chunks;
    }

    private InternalResponse createResponse(Message message) throws VPackParserException {
        InternalResponse response = this.serde.deserialize(message.getHead().toByteArray(), InternalResponse.class);
        if (message.getBody() != null) {
            response.setBody(message.getBody().toByteArray());
        }
        return response;
    }
}

