/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoGraph;
import com.arangodb.entity.EdgeEntity;
import com.arangodb.entity.EdgeUpdateEntity;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalArangoEdgeCollection;
import com.arangodb.internal.velocystream.internal.ConnectionSync;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.EdgeCreateOptions;
import com.arangodb.model.EdgeDeleteOptions;
import com.arangodb.model.EdgeReplaceOptions;
import com.arangodb.model.EdgeUpdateOptions;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoEdgeCollection
extends InternalArangoEdgeCollection<ArangoDB, ArangoDatabase, ArangoGraph, ArangoExecutorSync, Response, ConnectionSync> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoEdgeCollection.class);

    protected ArangoEdgeCollection(ArangoGraph graph, String name) {
        super(graph, name);
    }

    public <T> EdgeEntity insertEdge(T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertEdgeRequest(value, new EdgeCreateOptions()), this.insertEdgeResponseDeserializer(value));
    }

    public <T> EdgeEntity insertEdge(T value, EdgeCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.insertEdgeRequest(value, options), this.insertEdgeResponseDeserializer(value));
    }

    public <T> T getEdge(String key, Class<T> type) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getEdgeRequest(key, new DocumentReadOptions()), this.getEdgeResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public <T> T getEdge(String key, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        try {
            return ((ArangoExecutorSync)this.executor).execute(this.getEdgeRequest(key, options), this.getEdgeResponseDeserializer(type));
        }
        catch (ArangoDBException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public <T> EdgeUpdateEntity replaceEdge(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, new EdgeReplaceOptions()), this.replaceEdgeResponseDeserializer(value));
    }

    public <T> EdgeUpdateEntity replaceEdge(String key, T value, EdgeReplaceOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceEdgeRequest(key, value, options), this.replaceEdgeResponseDeserializer(value));
    }

    public <T> EdgeUpdateEntity updateEdge(String key, T value) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, new EdgeUpdateOptions()), this.updateEdgeResponseDeserializer(value));
    }

    public <T> EdgeUpdateEntity updateEdge(String key, T value, EdgeUpdateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.updateEdgeRequest(key, value, options), this.updateEdgeResponseDeserializer(value));
    }

    public void deleteEdge(String key) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, new EdgeDeleteOptions()), (Type)((Object)Void.class));
    }

    public void deleteEdge(String key, EdgeDeleteOptions options) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteEdgeRequest(key, options), (Type)((Object)Void.class));
    }
}

