/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.util.EncodeUtils;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Response;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ArangoExecutor {
    private static final String SLASH = "/";
    protected static final String REGEX_KEY = "[^/]+";
    protected static final String REGEX_ID = "[^/]+/[^/]+";
    private final DocumentCache documentCache;
    private final ArangoSerialization util;

    protected ArangoExecutor(ArangoSerialization util, DocumentCache documentCache) {
        this.documentCache = documentCache;
        this.util = util;
    }

    public DocumentCache documentCache() {
        return this.documentCache;
    }

    protected ArangoSerialization util() {
        return this.util;
    }

    protected String createPath(String ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(SLASH);
            }
            try {
                String param = params[i].contains(SLASH) ? this.createPath(params[i].split(SLASH)) : EncodeUtils.encodeURL(params[i]);
                sb.append(param);
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new ArangoDBException(e);
            }
        }
        return sb.toString();
    }

    public void validateIndexId(String id) {
        this.validateName("index id", REGEX_ID, id);
    }

    public void validateDocumentKey(String key) throws ArangoDBException {
        this.validateName("document key", REGEX_KEY, key);
    }

    public void validateDocumentId(String id) throws ArangoDBException {
        this.validateName("document id", REGEX_ID, id);
    }

    public String createDocumentHandle(String collection, String key) {
        this.validateDocumentKey(key);
        return new StringBuffer().append(collection).append(SLASH).append(key).toString();
    }

    protected void validateName(String type, String regex, CharSequence name) throws ArangoDBException {
        if (!Pattern.matches(regex, name)) {
            throw new ArangoDBException(String.format("%s %s is not valid.", type, name));
        }
    }

    protected <T> T createResult(Type type, Response response) {
        return type != Void.class && response.getBody() != null ? (T)this.deserialize(response.getBody(), type) : null;
    }

    @Deprecated
    protected <T> T deserialize(VPackSlice vpack, Type type) throws ArangoDBException {
        return this.util.deserialize(vpack, type);
    }

    @Deprecated
    protected VPackSlice serialize(Object entity) throws ArangoDBException {
        return this.util.serialize(entity);
    }

    @Deprecated
    protected VPackSlice serialize(Object entity, boolean serializeNullValues) throws ArangoDBException {
        return this.util.serialize(entity, new ArangoSerializer.Options().serializeNullValues(serializeNullValues));
    }

    @Deprecated
    protected VPackSlice serialize(Object entity, Type type) throws ArangoDBException {
        return this.util.serialize(entity, new ArangoSerializer.Options().type(type));
    }

    @Deprecated
    protected VPackSlice serialize(Object entity, Type type, boolean serializeNullValues) throws ArangoDBException {
        return this.util.serialize(entity, new ArangoSerializer.Options().type(type).serializeNullValues(serializeNullValues));
    }

    @Deprecated
    protected VPackSlice serialize(Object entity, Type type, Map<String, Object> additionalFields) throws ArangoDBException {
        return this.util.serialize(entity, new ArangoSerializer.Options().type(type).additionalFields(additionalFields));
    }

    public static interface ResponseDeserializer<T> {
        public T deserialize(Response var1) throws VPackException;
    }
}

