/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.lang.reflect.Type;

public class ArangoExecutorSync
extends ArangoExecutor {
    private final CommunicationProtocol protocol;

    public ArangoExecutorSync(CommunicationProtocol protocol, ArangoSerialization util, DocumentCache documentCache) {
        super(util, documentCache);
        this.protocol = protocol;
    }

    public <T> T execute(Request request, Type type) throws ArangoDBException {
        return this.execute(request, type, null);
    }

    public <T> T execute(Request request, final Type type, HostHandle hostHandle) throws ArangoDBException {
        return this.execute(request, new ArangoExecutor.ResponseDeserializer<T>(){

            @Override
            public T deserialize(Response response) throws VPackException {
                return ArangoExecutorSync.this.createResult(type, response);
            }
        }, hostHandle);
    }

    public <T> T execute(Request request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer) throws ArangoDBException {
        return this.execute(request, responseDeserializer, null);
    }

    public <T> T execute(Request request, ArangoExecutor.ResponseDeserializer<T> responseDeserializer, HostHandle hostHandle) throws ArangoDBException {
        try {
            Response response = this.protocol.execute(request, hostHandle);
            return responseDeserializer.deserialize(response);
        }
        catch (VPackException e) {
            throw new ArangoDBException(e);
        }
    }

    public void disconnect() {
        try {
            this.protocol.close();
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }
}

