/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.CollectionEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionCache.class);
    private static final long MAX_CACHE_TIME = 600000L;
    private final Map<String, Map<Long, CollectionInfo>> cache = new HashMap<String, Map<Long, CollectionInfo>>();
    private DBAccess access;
    private String db;

    public void init(DBAccess access) {
        this.access = access;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getCollectionName(long id) {
        CollectionInfo info = this.getInfo(id);
        return info != null ? info.name : null;
    }

    private CollectionInfo getInfo(long id) {
        CollectionInfo info;
        Map<Long, CollectionInfo> dbCache = this.cache.get(this.db);
        if (dbCache == null) {
            dbCache = new HashMap<Long, CollectionInfo>();
            this.cache.put(this.db, dbCache);
        }
        if ((info = dbCache.get(id)) == null || this.isExpired(info.time)) {
            try {
                String name = this.execute(id);
                info = new CollectionInfo(name, new Date().getTime());
                dbCache.put(id, info);
            }
            catch (ArangoDBException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return info;
    }

    private String execute(long id) throws ArangoDBException {
        CollectionEntity result = this.access.db(this.db).collection(String.valueOf(id)).getInfo();
        return result.getName();
    }

    private boolean isExpired(long time) {
        return new Date().getTime() > time + 600000L;
    }

    public static interface DBAccess {
        public ArangoDatabase db(String var1);
    }

    private static class CollectionInfo {
        private final String name;
        private final long time;

        public CollectionInfo(String name, long time) {
            this.name = name;
            this.time = time;
        }
    }
}

