/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.DocumentField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DocumentCache {
    private final Map<Class<?>, Map<DocumentField.Type, Field>> cache = new HashMap();

    public void setValues(Object doc, Map<DocumentField.Type, String> values) throws ArangoDBException {
        try {
            Map<DocumentField.Type, Field> fields = this.getFields(doc.getClass());
            for (Map.Entry<DocumentField.Type, String> value : values.entrySet()) {
                Field field = fields.get((Object)value.getKey());
                if (field == null) continue;
                field.set(doc, value.getValue());
            }
        }
        catch (IllegalArgumentException e) {
            throw new ArangoDBException(e);
        }
        catch (IllegalAccessException e) {
            throw new ArangoDBException(e);
        }
    }

    private Map<DocumentField.Type, Field> getFields(Class<?> clazz) {
        Map<DocumentField.Type, Field> fields = new HashMap<DocumentField.Type, Field>();
        if (!this.isTypeRestricted(clazz) && (fields = this.cache.get(clazz)) == null) {
            fields = this.createFields(clazz);
            this.cache.put(clazz, fields);
        }
        return fields;
    }

    private boolean isTypeRestricted(Class<?> type) {
        return Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type);
    }

    private Map<DocumentField.Type, Field> createFields(Class<?> clazz) {
        HashMap<DocumentField.Type, Field> fields = new HashMap<DocumentField.Type, Field>();
        ArrayList<DocumentField.Type> values = new ArrayList<DocumentField.Type>(Arrays.asList(DocumentField.Type.values()));
        for (Class<?> tmp = clazz; tmp != null && tmp != Object.class && values.size() > 0; tmp = tmp.getSuperclass()) {
            Field[] declaredFields = tmp.getDeclaredFields();
            for (int i = 0; i < declaredFields.length && values.size() > 0; ++i) {
                this.findAnnotation(values, fields, declaredFields[i]);
            }
        }
        return fields;
    }

    private void findAnnotation(Collection<DocumentField.Type> values, Map<DocumentField.Type, Field> fields, Field field) {
        DocumentField.Type value;
        DocumentField annotation = field.getAnnotation(DocumentField.class);
        if (annotation != null && !field.isSynthetic() && !Modifier.isStatic(field.getModifiers()) && String.class.isAssignableFrom(field.getType()) && values.contains((Object)(value = annotation.value()))) {
            field.setAccessible(true);
            fields.put(value, field);
            values.remove((Object)value);
        }
    }
}

