/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentField;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.ErrorEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.velocystream.internal.VstConnection;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionRenameOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.model.ImportType;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.SkiplistIndexOptions;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import com.arangodb.velocystream.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class InternalArangoCollection<A extends InternalArangoDB<E, R, C>, D extends InternalArangoDatabase<A, E, R, C>, E extends ArangoExecutor, R, C extends VstConnection>
extends ArangoExecuteable<E, R, C> {
    private final D db;
    private final String name;

    public InternalArangoCollection(D db, String name) {
        super(((ArangoExecuteable)db).executor(), ((ArangoExecuteable)db).util());
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected <T> Request insertDocumentRequest(T value, DocumentCreateOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, this.executor.createPath("/_api/document", this.name));
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("returnNew", params.getReturnNew());
        request.setBody(this.util().serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<DocumentCreateEntity<T>> insertDocumentResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<DocumentCreateEntity<T>>(){

            @Override
            public DocumentCreateEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody();
                DocumentCreateEntity doc = (DocumentCreateEntity)InternalArangoCollection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentCreateEntity.class));
                VPackSlice newDoc = body.get("new");
                if (newDoc.isObject()) {
                    doc.setNew(InternalArangoCollection.this.util().deserialize(newDoc, value.getClass()));
                }
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.ID, doc.getId());
                values.put(DocumentField.Type.KEY, doc.getKey());
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected <T> Request insertDocumentsRequest(Collection<T> values, DocumentCreateOptions params) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, this.executor.createPath("/_api/document", this.name));
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("returnNew", params.getReturnNew());
        request.setBody(this.util().serialize(values, new ArangoSerializer.Options().serializeNullValues(false).stringAsJson(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentCreateEntity<T>>> insertDocumentsResponseDeserializer(final Collection<T> values, final DocumentCreateOptions params) {
        return new ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentCreateEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentCreateEntity<T>> deserialize(Response response) throws VPackException {
                Class<?> type = null;
                if (params.getReturnNew() != null && params.getReturnNew().booleanValue() && !values.isEmpty()) {
                    type = values.iterator().next().getClass();
                }
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentCreateEntity> docs = new ArrayList<DocumentCreateEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentCreateEntity doc = (DocumentCreateEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentCreateEntity.class));
                    VPackSlice newDoc = next.get("new");
                    if (newDoc.isObject()) {
                        doc.setNew(InternalArangoCollection.this.util().deserialize(newDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected Request importDocumentsRequest(String values, DocumentImportOptions options) {
        return this.importDocumentsRequest(options).putQueryParam("type", (Object)ImportType.auto).setBody(this.util().serialize(values));
    }

    protected Request importDocumentsRequest(Collection<?> values, DocumentImportOptions options) {
        return this.importDocumentsRequest(options).putQueryParam("type", (Object)ImportType.list).setBody(this.util().serialize(values, new ArangoSerializer.Options().serializeNullValues(false).stringAsJson(true)));
    }

    protected Request importDocumentsRequest(DocumentImportOptions options) {
        DocumentImportOptions params = options != null ? options : new DocumentImportOptions();
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, "/_api/import").putQueryParam("collection", this.name).putQueryParam("fromPrefix", params.getFromPrefix()).putQueryParam("toPrefix", params.getToPrefix()).putQueryParam("overwrite", params.getOverwrite()).putQueryParam("waitForSync", params.getWaitForSync()).putQueryParam("onDuplicate", (Object)params.getOnDuplicate()).putQueryParam("complete", params.getComplete()).putQueryParam("details", params.getDetails());
    }

    protected Request getDocumentRequest(String key, DocumentReadOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/document", this.executor.createDocumentHandle(this.name, key)));
        DocumentReadOptions params = options != null ? options : new DocumentReadOptions();
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }

    protected Request getDocumentsRequest(Collection<String> keys, DocumentReadOptions options) {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/document", this.name)).putQueryParam("onlyget", true).putHeaderParam("If-None-Match", options.getIfNoneMatch()).putHeaderParam("If-Match", options.getIfMatch()).setBody(this.util().serialize(keys));
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<T>> getDocumentsResponseDeserializer(final Class<T> type, DocumentReadOptions options) {
        return new ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<T>>(){

            @Override
            public MultiDocumentEntity<T> deserialize(Response response) throws VPackException {
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList docs = new ArrayList();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    Object doc = InternalArangoCollection.this.util().deserialize(next, type);
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected <T> Request replaceDocumentRequest(String key, T value, DocumentReplaceOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/document", this.executor.createDocumentHandle(this.name, key)));
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("ignoreRevs", params.getIgnoreRevs());
        request.putQueryParam("returnNew", params.getReturnNew());
        request.putQueryParam("returnOld", params.getReturnOld());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util().serialize(value));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<DocumentUpdateEntity<T>> replaceDocumentResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<DocumentUpdateEntity<T>>(){

            @Override
            public DocumentUpdateEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice oldDoc;
                VPackSlice body = response.getBody();
                DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalArangoCollection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                VPackSlice newDoc = body.get("new");
                if (newDoc.isObject()) {
                    doc.setNew(InternalArangoCollection.this.util().deserialize(newDoc, value.getClass()));
                }
                if ((oldDoc = body.get("old")).isObject()) {
                    doc.setOld(InternalArangoCollection.this.util().deserialize(oldDoc, value.getClass()));
                }
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected <T> Request replaceDocumentsRequest(Collection<T> values, DocumentReplaceOptions params) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/document", this.name));
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("ignoreRevs", params.getIgnoreRevs());
        request.putQueryParam("returnNew", params.getReturnNew());
        request.putQueryParam("returnOld", params.getReturnOld());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util().serialize(values, new ArangoSerializer.Options().serializeNullValues(false).stringAsJson(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> replaceDocumentsResponseDeserializer(final Collection<T> values, final DocumentReplaceOptions params) {
        return new ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentUpdateEntity<T>> deserialize(Response response) throws VPackException {
                Class<?> type = null;
                if ((params.getReturnNew() != null && params.getReturnNew().booleanValue() || params.getReturnOld() != null && params.getReturnOld().booleanValue()) && !values.isEmpty()) {
                    type = values.iterator().next().getClass();
                }
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice oldDoc;
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                    VPackSlice newDoc = next.get("new");
                    if (newDoc.isObject()) {
                        doc.setNew(InternalArangoCollection.this.util().deserialize(newDoc, type));
                    }
                    if ((oldDoc = next.get("old")).isObject()) {
                        doc.setOld(InternalArangoCollection.this.util().deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected <T> Request updateDocumentRequest(String key, T value, DocumentUpdateOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.PATCH, this.executor.createPath("/_api/document", this.executor.createDocumentHandle(this.name, key)));
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        request.putQueryParam("keepNull", params.getKeepNull());
        request.putQueryParam("mergeObjects", params.getMergeObjects());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("ignoreRevs", params.getIgnoreRevs());
        request.putQueryParam("returnNew", params.getReturnNew());
        request.putQueryParam("returnOld", params.getReturnOld());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util().serialize(value, new ArangoSerializer.Options().serializeNullValues(params.getSerializeNull() == null || params.getSerializeNull() != false)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<DocumentUpdateEntity<T>> updateDocumentResponseDeserializer(final T value) {
        return new ArangoExecutor.ResponseDeserializer<DocumentUpdateEntity<T>>(){

            @Override
            public DocumentUpdateEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice oldDoc;
                VPackSlice body = response.getBody();
                DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalArangoCollection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                VPackSlice newDoc = body.get("new");
                if (newDoc.isObject()) {
                    doc.setNew(InternalArangoCollection.this.util().deserialize(newDoc, value.getClass()));
                }
                if ((oldDoc = body.get("old")).isObject()) {
                    doc.setOld(InternalArangoCollection.this.util().deserialize(oldDoc, value.getClass()));
                }
                HashMap<DocumentField.Type, String> values = new HashMap<DocumentField.Type, String>();
                values.put(DocumentField.Type.REV, doc.getRev());
                InternalArangoCollection.this.executor.documentCache().setValues(value, values);
                return doc;
            }
        };
    }

    protected <T> Request updateDocumentsRequest(Collection<T> values, DocumentUpdateOptions params) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.PATCH, this.executor.createPath("/_api/document", this.name));
        Boolean keepNull = params.getKeepNull();
        request.putQueryParam("keepNull", keepNull);
        request.putQueryParam("mergeObjects", params.getMergeObjects());
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("ignoreRevs", params.getIgnoreRevs());
        request.putQueryParam("returnNew", params.getReturnNew());
        request.putQueryParam("returnOld", params.getReturnOld());
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.setBody(this.util().serialize(values, new ArangoSerializer.Options().serializeNullValues(params.getSerializeNull() == null || params.getSerializeNull() != false).stringAsJson(true)));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>> updateDocumentsResponseDeserializer(final Collection<T> values, final DocumentUpdateOptions params) {
        return new ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentUpdateEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentUpdateEntity<T>> deserialize(Response response) throws VPackException {
                Class<?> type = null;
                if ((params.getReturnNew() != null && params.getReturnNew().booleanValue() || params.getReturnOld() != null && params.getReturnOld().booleanValue()) && !values.isEmpty()) {
                    type = values.iterator().next().getClass();
                }
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentUpdateEntity> docs = new ArrayList<DocumentUpdateEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice oldDoc;
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentUpdateEntity doc = (DocumentUpdateEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentUpdateEntity.class));
                    VPackSlice newDoc = next.get("new");
                    if (newDoc.isObject()) {
                        doc.setNew(InternalArangoCollection.this.util().deserialize(newDoc, type));
                    }
                    if ((oldDoc = next.get("old")).isObject()) {
                        doc.setOld(InternalArangoCollection.this.util().deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected Request deleteDocumentRequest(String key, DocumentDeleteOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, this.executor.createPath("/_api/document", this.executor.createDocumentHandle(this.name, key)));
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("returnOld", params.getReturnOld());
        request.putHeaderParam("If-Match", params.getIfMatch());
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<DocumentDeleteEntity<T>> deleteDocumentResponseDeserializer(final Class<T> type) {
        return new ArangoExecutor.ResponseDeserializer<DocumentDeleteEntity<T>>(){

            @Override
            public DocumentDeleteEntity<T> deserialize(Response response) throws VPackException {
                VPackSlice body = response.getBody();
                DocumentDeleteEntity doc = (DocumentDeleteEntity)InternalArangoCollection.this.util().deserialize(body, (java.lang.reflect.Type)((Object)DocumentDeleteEntity.class));
                VPackSlice oldDoc = body.get("old");
                if (oldDoc.isObject()) {
                    doc.setOld(InternalArangoCollection.this.util().deserialize(oldDoc, type));
                }
                return doc;
            }
        };
    }

    protected <T> Request deleteDocumentsRequest(Collection<T> keys, DocumentDeleteOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, this.executor.createPath("/_api/document", this.name));
        DocumentDeleteOptions params = options != null ? options : new DocumentDeleteOptions();
        request.putQueryParam("waitForSync", params.getWaitForSync());
        request.putQueryParam("returnOld", params.getReturnOld());
        request.setBody(this.util().serialize(keys));
        return request;
    }

    protected <T> ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentDeleteEntity<T>>> deleteDocumentsResponseDeserializer(final Class<T> type) {
        return new ArangoExecutor.ResponseDeserializer<MultiDocumentEntity<DocumentDeleteEntity<T>>>(){

            @Override
            public MultiDocumentEntity<DocumentDeleteEntity<T>> deserialize(Response response) throws VPackException {
                MultiDocumentEntity multiDocument = new MultiDocumentEntity();
                ArrayList<DocumentDeleteEntity> docs = new ArrayList<DocumentDeleteEntity>();
                ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
                ArrayList<Object> documentsAndErrors = new ArrayList<Object>();
                VPackSlice body = response.getBody();
                Iterator iterator = body.arrayIterator();
                while (iterator.hasNext()) {
                    VPackSlice next = (VPackSlice)iterator.next();
                    if (next.get("error").isTrue()) {
                        ErrorEntity error = (ErrorEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)ErrorEntity.class));
                        errors.add(error);
                        documentsAndErrors.add(error);
                        continue;
                    }
                    DocumentDeleteEntity doc = (DocumentDeleteEntity)InternalArangoCollection.this.util().deserialize(next, (java.lang.reflect.Type)((Object)DocumentDeleteEntity.class));
                    VPackSlice oldDoc = next.get("old");
                    if (oldDoc.isObject()) {
                        doc.setOld(InternalArangoCollection.this.util().deserialize(oldDoc, type));
                    }
                    docs.add(doc);
                    documentsAndErrors.add(doc);
                }
                multiDocument.setDocuments(docs);
                multiDocument.setErrors(errors);
                multiDocument.setDocumentsAndErrors(documentsAndErrors);
                return multiDocument;
            }
        };
    }

    protected Request documentExistsRequest(String key, DocumentExistsOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.HEAD, this.executor.createPath("/_api/document", this.executor.createDocumentHandle(this.name, key)));
        DocumentExistsOptions params = options != null ? options : new DocumentExistsOptions();
        request.putHeaderParam("If-Match", params.getIfMatch());
        request.putHeaderParam("If-None-Match", params.getIfNoneMatch());
        return request;
    }

    protected Request getIndexRequest(String id) {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/index", this.createIndexId(id)));
    }

    protected Request deleteIndexRequest(String id) {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, this.executor.createPath("/_api/index", this.createIndexId(id)));
    }

    protected ArangoExecutor.ResponseDeserializer<String> deleteIndexResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<String>(){

            @Override
            public String deserialize(Response response) throws VPackException {
                return response.getBody().get("id").getAsString();
            }
        };
    }

    private String createIndexId(String id) {
        String index;
        if (id.matches("[^/]+/[^/]+")) {
            index = id;
        } else if (id.matches("[^/]+")) {
            index = this.name + "/" + id;
        } else {
            throw new ArangoDBException(String.format("index id %s is not valid.", id));
        }
        return index;
    }

    protected Request createHashIndexRequest(Iterable<String> fields, HashIndexOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, "/_api/index");
        request.putQueryParam("collection", this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new HashIndexOptions(), fields)));
        return request;
    }

    protected Request createSkiplistIndexRequest(Iterable<String> fields, SkiplistIndexOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, "/_api/index");
        request.putQueryParam("collection", this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new SkiplistIndexOptions(), fields)));
        return request;
    }

    protected Request createPersistentIndexRequest(Iterable<String> fields, PersistentIndexOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, "/_api/index");
        request.putQueryParam("collection", this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new PersistentIndexOptions(), fields)));
        return request;
    }

    protected Request createGeoIndexRequest(Iterable<String> fields, GeoIndexOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, "/_api/index");
        request.putQueryParam("collection", this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new GeoIndexOptions(), fields)));
        return request;
    }

    protected Request createFulltextIndexRequest(Iterable<String> fields, FulltextIndexOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, "/_api/index");
        request.putQueryParam("collection", this.name);
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new FulltextIndexOptions(), fields)));
        return request;
    }

    protected Request getIndexesRequest() {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, "/_api/index");
        request.putQueryParam("collection", this.name);
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<IndexEntity>> getIndexesResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<IndexEntity>>(){

            @Override
            public Collection<IndexEntity> deserialize(Response response) throws VPackException {
                return (Collection)InternalArangoCollection.this.util().deserialize(response.getBody().get("indexes"), new Type<Collection<IndexEntity>>(){}.getType());
            }
        };
    }

    protected Request truncateRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/collection", this.name, "truncate"));
    }

    protected Request countRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/collection", this.name, "count"));
    }

    protected Request dropRequest(Boolean isSystem) {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, this.executor.createPath("/_api/collection", this.name)).putQueryParam("isSystem", isSystem);
    }

    protected Request loadRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/collection", this.name, "load"));
    }

    protected Request unloadRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/collection", this.name, "unload"));
    }

    protected Request getInfoRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/collection", this.name));
    }

    protected Request getPropertiesRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/collection", this.name, "properties"));
    }

    protected Request changePropertiesRequest(CollectionPropertiesOptions options) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/collection", this.name, "properties"));
        request.setBody(this.util().serialize(options != null ? options : new CollectionPropertiesOptions()));
        return request;
    }

    protected Request renameRequest(String newName) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/collection", this.name, "rename"));
        request.setBody(this.util().serialize(OptionsBuilder.build(new CollectionRenameOptions(), newName)));
        return request;
    }

    protected Request getRevisionRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/collection", this.name, "revision"));
    }

    protected Request grantAccessRequest(String user, Permissions permissions) {
        return new Request("_system", RequestType.PUT, this.executor.createPath("/_api/user", user, "database", ((InternalArangoDatabase)this.db).name(), this.name)).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request resetAccessRequest(String user) {
        return new Request("_system", RequestType.DELETE, this.executor.createPath("/_api/user", user, "database", ((InternalArangoDatabase)this.db).name(), this.name));
    }

    protected Request getPermissionsRequest(String user) {
        return new Request("_system", RequestType.GET, this.executor.createPath("/_api/user", user, "database", ((InternalArangoDatabase)this.db).name(), this.name));
    }

    protected ArangoExecutor.ResponseDeserializer<Permissions> getPermissionsResponseDeserialzer() {
        return new ArangoExecutor.ResponseDeserializer<Permissions>(){

            @Override
            public Permissions deserialize(Response response) throws VPackException {
                VPackSlice result;
                VPackSlice body = response.getBody();
                if (body != null && !(result = body.get("result")).isNone()) {
                    return (Permissions)((Object)InternalArangoCollection.this.util().deserialize(result, (java.lang.reflect.Type)((Object)Permissions.class)));
                }
                return null;
            }
        };
    }
}

