/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.Protocol;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoDBConstants;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.Host;
import com.arangodb.internal.velocystream.internal.VstConnection;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.UserAccessOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import com.arangodb.velocystream.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class InternalArangoDB<E extends ArangoExecutor, R, C extends VstConnection>
extends ArangoExecuteable<E, R, C> {
    private static final String PROPERTY_KEY_HOSTS = "arangodb.hosts";
    private static final String PROPERTY_KEY_HOST = "arangodb.host";
    private static final String PROPERTY_KEY_PORT = "arangodb.port";
    private static final String PROPERTY_KEY_TIMEOUT = "arangodb.timeout";
    private static final String PROPERTY_KEY_USER = "arangodb.user";
    private static final String PROPERTY_KEY_PASSWORD = "arangodb.password";
    private static final String PROPERTY_KEY_USE_SSL = "arangodb.usessl";
    private static final String PROPERTY_KEY_V_STREAM_CHUNK_CONTENT_SIZE = "arangodb.chunksize";
    private static final String PROPERTY_KEY_MAX_CONNECTIONS = "arangodb.connections.max";
    private static final String PROPERTY_KEY_CONNECTION_TTL = "arangodb.connections.ttl";
    private static final String PROPERTY_KEY_PROTOCOL = "arangodb.protocol";
    private static final String PROPERTY_KEY_ACQUIRE_HOST_LIST = "arangodb.acquireHostList";
    private static final String PROPERTY_KEY_LOAD_BALANCING_STRATEGY = "arangodb.loadBalancingStrategy";
    protected static final String DEFAULT_PROPERTY_FILE = "/arangodb.properties";

    public InternalArangoDB(E executor, ArangoSerialization util) {
        super(executor, util);
    }

    protected static void loadHosts(Properties properties, Collection<Host> hosts) {
        String hostsProp = properties.getProperty(PROPERTY_KEY_HOSTS);
        if (hostsProp != null) {
            String[] hostsSplit;
            for (String host : hostsSplit = hostsProp.split(",")) {
                String[] split = host.split(":");
                if (split.length != 2 || !split[1].matches("[0-9]+")) {
                    throw new ArangoDBException(String.format("Could not load property-value arangodb.hosts=%s. Expected format ip:port,ip:port,...", hostsProp));
                }
                hosts.add(new Host(split[0], Integer.valueOf(split[1])));
            }
        }
    }

    protected static String loadHost(Properties properties, String currentValue) {
        String host = InternalArangoDB.getProperty(properties, PROPERTY_KEY_HOST, currentValue, "127.0.0.1");
        if (host.contains(":")) {
            throw new ArangoDBException(String.format("Could not load property-value arangodb.host=%s. Expect only ip. Do you mean arangodb.hosts=ip:port ?", host));
        }
        return host;
    }

    protected static Integer loadPort(Properties properties, int currentValue) {
        return Integer.parseInt(InternalArangoDB.getProperty(properties, PROPERTY_KEY_PORT, currentValue, ArangoDBConstants.DEFAULT_PORT));
    }

    protected static Integer loadTimeout(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDB.getProperty(properties, PROPERTY_KEY_TIMEOUT, currentValue, ArangoDBConstants.DEFAULT_TIMEOUT));
    }

    protected static String loadUser(Properties properties, String currentValue) {
        return InternalArangoDB.getProperty(properties, PROPERTY_KEY_USER, currentValue, "root");
    }

    protected static String loadPassword(Properties properties, String currentValue) {
        return InternalArangoDB.getProperty(properties, PROPERTY_KEY_PASSWORD, currentValue, null);
    }

    protected static Boolean loadUseSsl(Properties properties, Boolean currentValue) {
        return Boolean.parseBoolean(InternalArangoDB.getProperty(properties, PROPERTY_KEY_USE_SSL, currentValue, ArangoDBConstants.DEFAULT_USE_SSL));
    }

    protected static Integer loadChunkSize(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDB.getProperty(properties, PROPERTY_KEY_V_STREAM_CHUNK_CONTENT_SIZE, currentValue, 30000));
    }

    protected static Integer loadMaxConnections(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDB.getProperty(properties, PROPERTY_KEY_MAX_CONNECTIONS, currentValue, 1));
    }

    protected static Long loadConnectionTtl(Properties properties, Long currentValue) {
        String ttl = InternalArangoDB.getProperty(properties, PROPERTY_KEY_CONNECTION_TTL, currentValue, ArangoDBConstants.CONNECTION_TTL_VST_DEFAULT);
        return ttl != null ? Long.valueOf(Long.parseLong(ttl)) : null;
    }

    protected static Protocol loadProtocol(Properties properties, Protocol currentValue) {
        return Protocol.valueOf(InternalArangoDB.getProperty(properties, PROPERTY_KEY_PROTOCOL, currentValue, ArangoDBConstants.DEFAULT_NETWORK_PROTOCOL).toUpperCase());
    }

    protected static Boolean loadAcquireHostList(Properties properties, Boolean currentValue) {
        return Boolean.parseBoolean(InternalArangoDB.getProperty(properties, PROPERTY_KEY_ACQUIRE_HOST_LIST, currentValue, false));
    }

    protected static LoadBalancingStrategy loadLoadBalancingStrategy(Properties properties, LoadBalancingStrategy currentValue) {
        return LoadBalancingStrategy.valueOf(InternalArangoDB.getProperty(properties, PROPERTY_KEY_LOAD_BALANCING_STRATEGY, currentValue, ArangoDBConstants.DEFAULT_LOAD_BALANCING_STRATEGY).toUpperCase());
    }

    private static <T> String getProperty(Properties properties, String key, T currentValue, T defaultValue) {
        return properties.getProperty(key, currentValue != null ? currentValue.toString() : (defaultValue != null ? defaultValue.toString() : null));
    }

    protected Request getRoleRequest() {
        return new Request("_system", RequestType.GET, "/_admin/server/role");
    }

    protected ArangoExecutor.ResponseDeserializer<ServerRole> getRoleResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<ServerRole>(){

            @Override
            public ServerRole deserialize(Response response) throws VPackException {
                return (ServerRole)((Object)InternalArangoDB.this.util().deserialize(response.getBody().get("role"), (java.lang.reflect.Type)((Object)ServerRole.class)));
            }
        };
    }

    protected Request createDatabaseRequest(String name) {
        Request request = new Request("_system", RequestType.POST, "/_api/database");
        request.setBody(this.util().serialize(OptionsBuilder.build(new DBCreateOptions(), name)));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<Boolean> createDatabaseResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Boolean>(){

            @Override
            public Boolean deserialize(Response response) throws VPackException {
                return response.getBody().get("result").getAsBoolean();
            }
        };
    }

    protected Request getDatabasesRequest(String database) {
        return new Request(database, RequestType.GET, "/_api/database");
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getDatabaseResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Collection)InternalArangoDB.this.util().deserialize(result, new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request getAccessibleDatabasesForRequest(String database, String user) {
        return new Request(database, RequestType.GET, this.executor.createPath("/_api/user", user, "database"));
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getAccessibleDatabasesForResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                ArrayList<String> dbs = new ArrayList<String>();
                Iterator iterator = result.objectIterator();
                while (iterator.hasNext()) {
                    dbs.add((String)((Map.Entry)iterator.next()).getKey());
                }
                return dbs;
            }
        };
    }

    protected Request createUserRequest(String database, String user, String passwd, UserCreateOptions options) {
        Request request = new Request(database, RequestType.POST, "/_api/user");
        request.setBody(this.util().serialize(OptionsBuilder.build(options != null ? options : new UserCreateOptions(), user, passwd)));
        return request;
    }

    protected Request deleteUserRequest(String database, String user) {
        return new Request(database, RequestType.DELETE, this.executor.createPath("/_api/user", user));
    }

    protected Request getUsersRequest(String database) {
        return new Request(database, RequestType.GET, "/_api/user");
    }

    protected Request getUserRequest(String database, String user) {
        return new Request(database, RequestType.GET, this.executor.createPath("/_api/user", user));
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<UserEntity>> getUsersResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<UserEntity>>(){

            @Override
            public Collection<UserEntity> deserialize(Response response) throws VPackException {
                VPackSlice result = response.getBody().get("result");
                return (Collection)InternalArangoDB.this.util().deserialize(result, new Type<Collection<UserEntity>>(){}.getType());
            }
        };
    }

    protected Request updateUserRequest(String database, String user, UserUpdateOptions options) {
        Request request = new Request(database, RequestType.PATCH, this.executor.createPath("/_api/user", user));
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request replaceUserRequest(String database, String user, UserUpdateOptions options) {
        Request request = new Request(database, RequestType.PUT, this.executor.createPath("/_api/user", user));
        request.setBody(this.util().serialize(options != null ? options : new UserUpdateOptions()));
        return request;
    }

    protected Request updateUserDefaultDatabaseAccessRequest(String user, Permissions permissions) {
        return new Request("_system", RequestType.PUT, this.executor.createPath("/_api/user", user, "database", "*")).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request updateUserDefaultCollectionAccessRequest(String user, Permissions permissions) {
        return new Request("_system", RequestType.PUT, this.executor.createPath("/_api/user", user, "database", "*", "*")).setBody(this.util().serialize(OptionsBuilder.build(new UserAccessOptions(), permissions)));
    }

    protected Request getLogsRequest(LogOptions options) {
        LogOptions params = options != null ? options : new LogOptions();
        return new Request("_system", RequestType.GET, "/_admin/log").putQueryParam("upto", (Object)params.getUpto()).putQueryParam("level", (Object)params.getLevel()).putQueryParam("start", params.getStart()).putQueryParam("size", params.getSize()).putQueryParam("offset", params.getOffset()).putQueryParam("search", params.getSearch()).putQueryParam("sort", (Object)params.getSort());
    }

    protected Request getLogLevelRequest() {
        return new Request("_system", RequestType.GET, "/_admin/log/level");
    }

    protected Request setLogLevelRequest(LogLevelEntity entity) {
        return new Request("_system", RequestType.PUT, "/_admin/log/level").setBody(this.util().serialize(entity));
    }
}

