/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.internal.ArangoExecuteable;
import com.arangodb.internal.ArangoExecutor;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.InternalArangoDatabase;
import com.arangodb.internal.velocystream.internal.VstConnection;
import com.arangodb.model.OptionsBuilder;
import com.arangodb.model.VertexCollectionCreateOptions;
import com.arangodb.velocypack.Type;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import com.arangodb.velocystream.Response;
import java.util.Collection;

public class InternalArangoGraph<A extends InternalArangoDB<E, R, C>, D extends InternalArangoDatabase<A, E, R, C>, E extends ArangoExecutor, R, C extends VstConnection>
extends ArangoExecuteable<E, R, C> {
    private final D db;
    private final String name;

    public InternalArangoGraph(D db, String name) {
        super(((ArangoExecuteable)db).executor(), ((ArangoExecuteable)db).util());
        this.db = db;
        this.name = name;
    }

    public D db() {
        return this.db;
    }

    public String name() {
        return this.name;
    }

    protected Request dropRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, this.executor.createPath("/_api/gharial", this.name));
    }

    protected Request getInfoRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/gharial", this.name));
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> getInfoResponseDeserializer() {
        return this.addVertexCollectionResponseDeserializer();
    }

    protected Request getVertexCollectionsRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/gharial", this.name, "vertex"));
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getVertexCollectionsResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                return (Collection)InternalArangoGraph.this.util().deserialize(response.getBody().get("collections"), new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request addVertexCollectionRequest(String name) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, this.executor.createPath("/_api/gharial", this.name(), "vertex"));
        request.setBody(this.util().serialize(OptionsBuilder.build(new VertexCollectionCreateOptions(), name)));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> addVertexCollectionResponseDeserializer() {
        return this.addEdgeDefinitionResponseDeserializer();
    }

    protected Request getEdgeDefinitionsRequest() {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.GET, this.executor.createPath("/_api/gharial", this.name, "edge"));
    }

    protected ArangoExecutor.ResponseDeserializer<Collection<String>> getEdgeDefinitionsDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<Collection<String>>(){

            @Override
            public Collection<String> deserialize(Response response) throws VPackException {
                return (Collection)InternalArangoGraph.this.util().deserialize(response.getBody().get("collections"), new Type<Collection<String>>(){}.getType());
            }
        };
    }

    protected Request addEdgeDefinitionRequest(EdgeDefinition definition) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.POST, this.executor.createPath("/_api/gharial", this.name, "edge"));
        request.setBody(this.util().serialize(definition));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> addEdgeDefinitionResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalArangoGraph.this.util().deserialize(response.getBody().get("graph"), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request replaceEdgeDefinitionRequest(EdgeDefinition definition) {
        Request request = new Request(((InternalArangoDatabase)this.db).name(), RequestType.PUT, this.executor.createPath("/_api/gharial", this.name, "edge", definition.getCollection()));
        request.setBody(this.util().serialize(definition));
        return request;
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> replaceEdgeDefinitionResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalArangoGraph.this.util().deserialize(response.getBody().get("graph"), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }

    protected Request removeEdgeDefinitionRequest(String definitionName) {
        return new Request(((InternalArangoDatabase)this.db).name(), RequestType.DELETE, this.executor.createPath("/_api/gharial", this.name, "edge", definitionName));
    }

    protected ArangoExecutor.ResponseDeserializer<GraphEntity> removeEdgeDefinitionResponseDeserializer() {
        return new ArangoExecutor.ResponseDeserializer<GraphEntity>(){

            @Override
            public GraphEntity deserialize(Response response) throws VPackException {
                return (GraphEntity)InternalArangoGraph.this.util().deserialize(response.getBody().get("graph"), (java.lang.reflect.Type)((Object)GraphEntity.class));
            }
        };
    }
}

