/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.http;

import com.arangodb.ArangoDBException;
import com.arangodb.Protocol;
import com.arangodb.internal.Host;
import com.arangodb.internal.http.HttpConnection;
import com.arangodb.internal.net.ArangoDBRedirectException;
import com.arangodb.internal.net.ConnectionPool;
import com.arangodb.internal.net.DelHostHandler;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import javax.net.ssl.SSLContext;

public class HttpCommunication {
    private final ConnectionPool<HttpConnection> connectionPool;

    private HttpCommunication(final Integer timeout, final String user, final String password, final Boolean useSsl, final SSLContext sslContext, final ArangoSerialization util, final HostHandler hostHandler, Integer maxConnections, final Protocol contentType, final Long connectionTtl) {
        this.connectionPool = new ConnectionPool<HttpConnection>(Integer.valueOf(maxConnections != null ? Math.max(1, maxConnections) : 20)){

            @Override
            public HttpConnection createConnection(Host host) {
                return new HttpConnection(timeout, user, password, useSsl, sslContext, util, new DelHostHandler(hostHandler, host), contentType, connectionTtl);
            }
        };
    }

    public void disconnect() throws IOException {
        this.connectionPool.disconnect();
    }

    public Response execute(Request request, HostHandle hostHandle) throws ArangoDBException, IOException {
        HttpConnection connection = this.connectionPool.connection(hostHandle);
        try {
            return this.execute(request, connection);
        }
        catch (ArangoDBException e) {
            if (e instanceof ArangoDBRedirectException) {
                String location = ((ArangoDBRedirectException)ArangoDBRedirectException.class.cast(e)).getLocation();
                Host host = HostUtils.createFromLocation(location);
                this.connectionPool.closeConnectionOnError(connection);
                return this.execute(request, new HostHandle().setHost(host));
            }
            throw e;
        }
    }

    protected Response execute(Request request, HttpConnection connection) throws ArangoDBException, IOException {
        return connection.execute(request);
    }

    public static class Builder {
        private final HostHandler hostHandler;
        private final Protocol protocol;
        private Integer timeout;
        private Long connectionTtl;
        private String user;
        private String password;
        private Boolean useSsl;
        private SSLContext sslContext;
        private Integer maxConnections;

        public Builder(HostHandler hostHandler, Protocol protocol) {
            this.hostHandler = hostHandler;
            this.protocol = protocol;
        }

        public Builder(Builder builder) {
            this(builder.hostHandler, builder.protocol);
            this.timeout(builder.timeout).user(builder.user).password(builder.password).useSsl(builder.useSsl).sslContext(builder.sslContext).maxConnections(builder.maxConnections);
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.useSsl = useSsl;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.connectionTtl = connectionTtl;
            return this;
        }

        public HttpCommunication build(ArangoSerialization util) {
            return new HttpCommunication(this.timeout, this.user, this.password, this.useSsl, this.sslContext, util, this.hostHandler, this.maxConnections, this.protocol, this.connectionTtl);
        }
    }
}

