/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.ArangoDBException;
import com.arangodb.internal.Host;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.HostHandle;
import java.io.IOException;
import java.util.LinkedList;

public abstract class ConnectionPool<C extends Connection> {
    private final LinkedList<C> connections;
    private final int maxConnections;

    public ConnectionPool(Integer maxConnections) {
        this.maxConnections = maxConnections;
        this.connections = new LinkedList();
    }

    public abstract C createConnection(Host var1);

    public synchronized C connection(HostHandle hostHandle) {
        Object c;
        if (hostHandle == null || hostHandle.getHost() == null) {
            c = this.connections.size() < this.maxConnections ? this.createConnection(null) : (Connection)this.connections.removeFirst();
            if (hostHandle != null) {
                hostHandle.setHost(c.getHost());
            }
        } else {
            Host host = hostHandle.getHost();
            Connection tmp = null;
            for (Connection connection : this.connections) {
                if (!connection.getHost().equals(host)) continue;
                tmp = connection;
                this.connections.remove(tmp);
                break;
            }
            c = tmp != null ? tmp : (Connection)this.createConnection(host);
        }
        this.connections.add(c);
        return (C)c;
    }

    public void disconnect() throws IOException {
        while (!this.connections.isEmpty()) {
            ((Connection)this.connections.removeLast()).close();
        }
    }

    public void closeConnection(C connection) {
        try {
            connection.close();
            this.connections.remove(connection);
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    public void closeConnectionOnError(C connection) {
        try {
            connection.closeOnError();
            this.connections.remove(connection);
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }
}

