/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.Host;
import com.arangodb.internal.net.HostResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExtendedHostResolver
implements HostResolver {
    private static final long MAX_CACHE_TIME = 3600000L;
    private HostResolver.EndpointResolver resolver;
    private final List<Host> hosts;
    private long lastUpdate;

    public ExtendedHostResolver(List<Host> hosts) {
        this.hosts = new ArrayList<Host>(hosts);
        this.lastUpdate = 0L;
    }

    @Override
    public void init(HostResolver.EndpointResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public List<Host> resolve(boolean initial, boolean closeConnections) {
        if (!initial && this.isExpired()) {
            this.lastUpdate = System.currentTimeMillis();
            Collection<String> endpoints = this.resolver.resolve(closeConnections);
            if (!endpoints.isEmpty()) {
                this.hosts.clear();
            }
            for (String endpoint : endpoints) {
                String[] s;
                if (!endpoint.matches(".*://.+:[0-9]+") || (s = endpoint.replaceAll(".*://", "").split(":")).length != 2) continue;
                this.hosts.add(new Host(s[0], Integer.valueOf(s[1])));
            }
        }
        return this.hosts;
    }

    private boolean isExpired() {
        return System.currentTimeMillis() > this.lastUpdate + 3600000L;
    }
}

