/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.Host;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import java.util.List;

public class FallbackHostHandler
implements HostHandler {
    private Host current;
    private Host lastSuccess;
    private int iterations;
    private final HostResolver resolver;

    public FallbackHostHandler(HostResolver resolver) {
        this.resolver = resolver;
        this.iterations = 0;
        this.current = this.lastSuccess = resolver.resolve(true, false).get(0);
    }

    @Override
    public Host get() {
        return this.current != this.lastSuccess || this.iterations < 3 ? this.current : null;
    }

    @Override
    public void success() {
        this.lastSuccess = this.current;
    }

    @Override
    public void fail() {
        List<Host> hosts = this.resolver.resolve(false, false);
        int index = hosts.indexOf(this.current) + 1;
        boolean inBound = index < hosts.size();
        this.current = hosts.get(inBound ? index : 0);
        if (!inBound) {
            ++this.iterations;
        }
    }

    @Override
    public void reset() {
        this.iterations = 0;
    }
}

