/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.Host;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import java.util.ArrayList;
import java.util.Collections;

public class RandomHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private final HostHandler fallback;
    private Host origin;
    private Host current;

    public RandomHostHandler(HostResolver resolver, HostHandler fallback) {
        this.resolver = resolver;
        this.fallback = fallback;
        this.origin = this.current = this.getRandomHost(true, false);
    }

    @Override
    public Host get() {
        if (this.current == null) {
            this.origin = this.current = this.getRandomHost(false, true);
        }
        return this.current;
    }

    @Override
    public void success() {
        this.current = this.origin;
    }

    @Override
    public void fail() {
        this.fallback.fail();
        this.current = this.fallback.get();
    }

    private Host getRandomHost(boolean initial, boolean closeConnections) {
        ArrayList<Host> hosts = new ArrayList<Host>(this.resolver.resolve(initial, closeConnections));
        Collections.shuffle(hosts);
        return hosts.get(0);
    }

    @Override
    public void reset() {
        this.fallback.reset();
    }
}

