/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.net;

import com.arangodb.internal.Host;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import java.util.List;

public class RoundRobinHostHandler
implements HostHandler {
    private final HostResolver resolver;
    private Host current;
    private int fails;

    public RoundRobinHostHandler(HostResolver resolver) {
        this.resolver = resolver;
        this.current = resolver.resolve(true, false).get(0);
        this.fails = 0;
    }

    @Override
    public Host get() {
        List<Host> hosts = this.resolver.resolve(false, false);
        if (this.fails > hosts.size()) {
            return null;
        }
        int index = hosts.indexOf(this.current) + 1;
        this.current = hosts.get(index < hosts.size() ? index : 0);
        return this.current;
    }

    @Override
    public void success() {
        this.fails = 0;
    }

    @Override
    public void fail() {
        ++this.fails;
    }

    @Override
    public void reset() {
        this.fails = 0;
    }
}

