/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.RequestType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.http.auth.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CURLLogger {
    private static Logger LOGGER = LoggerFactory.getLogger(CURLLogger.class);

    private CURLLogger() {
    }

    public static void log(String url, Request request, Credentials credencials, ArangoSerialization util) {
        RequestType requestType = request.getRequestType();
        boolean includeBody = (requestType == RequestType.POST || requestType == RequestType.PUT || requestType == RequestType.PATCH || requestType == RequestType.DELETE) && request.getBody() != null;
        StringBuilder buffer = new StringBuilder();
        if (includeBody) {
            buffer.append("\n");
            buffer.append("cat <<-___EOB___ | ");
        }
        buffer.append("curl -X ").append((Object)requestType);
        buffer.append(" --dump -");
        if (request.getHeaderParam().size() > 0) {
            for (Map.Entry<String, String> header : request.getHeaderParam().entrySet()) {
                buffer.append(" -H '").append(header.getKey()).append(":").append(header.getValue()).append("'");
            }
        }
        if (credencials != null) {
            buffer.append(" -u ").append(credencials.getUserPrincipal().getName()).append(":").append(credencials.getPassword());
        }
        if (includeBody) {
            buffer.append(" -d @-");
        }
        buffer.append(" '").append(url).append("'");
        if (includeBody) {
            buffer.append("\n");
            buffer.append((String)util.deserialize(request.getBody(), (Type)((Object)String.class)));
            buffer.append("\n");
            buffer.append("___EOB___");
        }
        LOGGER.debug("[CURL] {}", (Object)buffer);
    }
}

