/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionStatus;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryExecutionState;
import com.arangodb.velocypack.VPackDeserializationContext;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import com.arangodb.velocystream.Response;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPackDeserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPackDeserializers.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final VPackDeserializer<Response> RESPONSE = new VPackDeserializer<Response>(){

        public Response deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            Response response = new Response();
            response.setVersion(vpack.get(0).getAsInt());
            response.setType(vpack.get(1).getAsInt());
            response.setResponseCode(vpack.get(2).getAsInt());
            if (vpack.size() > 3) {
                response.setMeta((Map)context.deserialize(vpack.get(3), Map.class));
            }
            return response;
        }
    };
    public static final VPackDeserializer<CollectionType> COLLECTION_TYPE = new VPackDeserializer<CollectionType>(){

        public CollectionType deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return CollectionType.fromType(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<CollectionStatus> COLLECTION_STATUS = new VPackDeserializer<CollectionStatus>(){

        public CollectionStatus deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return CollectionStatus.fromStatus(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<BaseDocument> BASE_DOCUMENT = new VPackDeserializer<BaseDocument>(){

        public BaseDocument deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return new BaseDocument((Map)context.deserialize(vpack, Map.class));
        }
    };
    public static final VPackDeserializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = new VPackDeserializer<BaseEdgeDocument>(){

        public BaseEdgeDocument deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return new BaseEdgeDocument((Map)context.deserialize(vpack, Map.class));
        }
    };
    public static final VPackDeserializer<Date> DATE_STRING = new VPackDeserializer<Date>(){

        public Date deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            try {
                return new SimpleDateFormat(VPackDeserializers.DATE_TIME_FORMAT).parse(vpack.getAsString());
            }
            catch (ParseException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("got ParseException for date string: " + vpack.getAsString());
                }
                return null;
            }
        }
    };
    public static final VPackDeserializer<LogLevel> LOG_LEVEL = new VPackDeserializer<LogLevel>(){

        public LogLevel deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return LogLevel.fromLevel(vpack.getAsInt());
        }
    };
    public static final VPackDeserializer<ArangoDBVersion.License> LICENSE = new VPackDeserializer<ArangoDBVersion.License>(){

        public ArangoDBVersion.License deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return ArangoDBVersion.License.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<Permissions> PERMISSIONS = new VPackDeserializer<Permissions>(){

        public Permissions deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return Permissions.valueOf(vpack.getAsString().toUpperCase());
        }
    };
    public static final VPackDeserializer<QueryExecutionState> QUERY_EXECUTION_STATE = new VPackDeserializer<QueryExecutionState>(){

        public QueryExecutionState deserialize(VPackSlice parent, VPackSlice vpack, VPackDeserializationContext context) throws VPackException {
            return QueryExecutionState.valueOf(vpack.getAsString().toUpperCase().replaceAll(" ", "_"));
        }
    };
}

